/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public final class HttpDownloader {
    public static final int INTERVAL = 500;
    public final AtomicInteger writed = new AtomicInteger(0);
    public final Thread thread = new Thread(() -> {
        try {
            this.filename = IOHelper.getFileName(path);
            HttpDownloader.downloadFile(uRL, path, this.writed::set);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    });
    private volatile String filename = null;

    public HttpDownloader(URL uRL, Path path) {
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public static void downloadFile(URL uRL, Path path, Consumer<Integer> consumer) {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
             OutputStream outputStream = IOHelper.newOutput(path, false);){
            int n;
            byte[] byArray = new byte[IOHelper.BUFFER_SIZE];
            long l = System.currentTimeMillis();
            int n2 = 0;
            while ((n = bufferedInputStream.read(byArray, 0, IOHelper.BUFFER_SIZE)) != -1) {
                outputStream.write(byArray, 0, n);
                n2 += n;
                if (System.currentTimeMillis() - l <= 500L) continue;
                consumer.accept(n2);
                LogHelper.debug("Downloaded %d", n2);
            }
            consumer.accept(n2);
        }
    }

    public static void downloadZip(URL uRL, Path path) {
        try (ZipInputStream zipInputStream = IOHelper.newZipInput(uRL);){
            Files.createDirectory(path, new FileAttribute[0]);
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                if (zipEntry.isDirectory()) {
                    Files.createDirectory(path.resolve(IOHelper.toPath(zipEntry.getName())), new FileAttribute[0]);
                } else {
                    String string = zipEntry.getName();
                    LogHelper.subInfo("Downloading file: '%s'", string);
                    IOHelper.transfer((InputStream)zipInputStream, path.resolve(IOHelper.toPath(string)));
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
    }

    public String getFilename() {
        return this.filename;
    }
}

