/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util.collection;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import pro.gravit.repackage.io.netty.util.collection.ByteObjectHashMap$1;
import pro.gravit.repackage.io.netty.util.collection.ByteObjectHashMap$2;
import pro.gravit.repackage.io.netty.util.collection.ByteObjectHashMap$EntrySet;
import pro.gravit.repackage.io.netty.util.collection.ByteObjectHashMap$KeySet;
import pro.gravit.repackage.io.netty.util.collection.ByteObjectMap;
import pro.gravit.repackage.io.netty.util.internal.MathUtil;

public class ByteObjectHashMap<V>
implements ByteObjectMap<V> {
    public static final int DEFAULT_CAPACITY = 8;
    public static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final Object NULL_VALUE = new Object();
    private int maxSize;
    private final float loadFactor;
    private byte[] keys;
    private V[] values;
    private int size;
    private int mask;
    private final Set<Byte> keySet = new ByteObjectHashMap$KeySet(this, null);
    private final Set<Map.Entry<Byte, V>> entrySet = new ByteObjectHashMap$EntrySet(this, null);
    private final Iterable<ByteObjectMap.PrimitiveEntry<V>> entries = new ByteObjectHashMap$1(this);

    public ByteObjectHashMap() {
        this(8, 0.5f);
    }

    public ByteObjectHashMap(int n) {
        this(n, 0.5f);
    }

    public ByteObjectHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1");
        }
        this.loadFactor = f;
        int n2 = MathUtil.safeFindNextPositivePowerOfTwo(n);
        this.mask = n2 - 1;
        this.keys = new byte[n2];
        Object[] objectArray = new Object[n2];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n2);
    }

    private static <T> T toExternal(T t) {
        assert (t != null) : "null is not a legitimate internal value. Concurrent Modification?";
        return t == NULL_VALUE ? null : (T)t;
    }

    private static <T> T toInternal(T t) {
        return (T)(t == null ? NULL_VALUE : t);
    }

    @Override
    public V get(byte by) {
        int n = this.indexOf(by);
        return n == -1 ? null : (V)ByteObjectHashMap.toExternal(this.values[n]);
    }

    @Override
    public V put(byte by, V v) {
        int n;
        int n2 = n = this.hashIndex(by);
        do {
            if (this.values[n2] == null) {
                this.keys[n2] = by;
                this.values[n2] = ByteObjectHashMap.toInternal(v);
                this.growSize();
                return null;
            }
            if (this.keys[n2] != by) continue;
            V v2 = this.values[n2];
            this.values[n2] = ByteObjectHashMap.toInternal(v);
            return ByteObjectHashMap.toExternal(v2);
        } while ((n2 = this.probeNext(n2)) != n);
        throw new IllegalStateException("Unable to insert");
    }

    @Override
    public void putAll(Map<? extends Byte, ? extends V> map) {
        if (map instanceof ByteObjectHashMap) {
            ByteObjectHashMap byteObjectHashMap = (ByteObjectHashMap)map;
            for (int i = 0; i < byteObjectHashMap.values.length; ++i) {
                V v = byteObjectHashMap.values[i];
                if (v == null) continue;
                this.put(byteObjectHashMap.keys[i], v);
            }
            return;
        }
        for (Map.Entry<Byte, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(byte by) {
        int n = this.indexOf(by);
        if (n == -1) {
            return null;
        }
        V v = this.values[n];
        this.removeAt(n);
        return ByteObjectHashMap.toExternal(v);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, (byte)0);
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    @Override
    public boolean containsKey(byte by) {
        return this.indexOf(by) >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        Object object2 = ByteObjectHashMap.toInternal(object);
        for (V v : this.values) {
            if (v == null || !v.equals(object2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<ByteObjectMap.PrimitiveEntry<V>> entries() {
        return this.entries;
    }

    @Override
    public Collection<V> values() {
        return new ByteObjectHashMap$2(this);
    }

    @Override
    public int hashCode() {
        int n = this.size;
        for (byte by : this.keys) {
            n ^= ByteObjectHashMap.hashCode(by);
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ByteObjectMap)) {
            return false;
        }
        ByteObjectMap byteObjectMap = (ByteObjectMap)object;
        if (this.size != byteObjectMap.size()) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            V v = this.values[i];
            if (v == null) continue;
            byte by = this.keys[i];
            Object v2 = byteObjectMap.get(by);
            if (!(v == NULL_VALUE ? v2 != null : !v.equals(v2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.containsKey(this.objectToKey(object));
    }

    @Override
    public V get(Object object) {
        return this.get(this.objectToKey(object));
    }

    @Override
    public V put(Byte by, V v) {
        return this.put(this.objectToKey(by), v);
    }

    @Override
    public V remove(Object object) {
        return this.remove(this.objectToKey(object));
    }

    @Override
    public Set<Byte> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<Byte, V>> entrySet() {
        return this.entrySet;
    }

    private byte objectToKey(Object object) {
        return (Byte)object;
    }

    private int indexOf(byte by) {
        int n;
        int n2 = n = this.hashIndex(by);
        do {
            if (this.values[n2] == null) {
                return -1;
            }
            if (by != this.keys[n2]) continue;
            return n2;
        } while ((n2 = this.probeNext(n2)) != n);
        return -1;
    }

    private int hashIndex(byte by) {
        return ByteObjectHashMap.hashCode(by) & this.mask;
    }

    private static int hashCode(byte by) {
        return by;
    }

    private int probeNext(int n) {
        return n + 1 & this.mask;
    }

    private void growSize() {
        ++this.size;
        if (this.size > this.maxSize) {
            if (this.keys.length == Integer.MAX_VALUE) {
                throw new IllegalStateException("Max capacity reached at size=" + this.size);
            }
            this.rehash(this.keys.length << 1);
        }
    }

    private boolean removeAt(int n) {
        --this.size;
        this.keys[n] = 0;
        this.values[n] = null;
        int n2 = n;
        int n3 = this.probeNext(n);
        V v = this.values[n3];
        while (v != null) {
            byte by = this.keys[n3];
            int n4 = this.hashIndex(by);
            if (n3 < n4 && (n4 <= n2 || n2 <= n3) || n4 <= n2 && n2 <= n3) {
                this.keys[n2] = by;
                this.values[n2] = v;
                this.keys[n3] = 0;
                this.values[n3] = null;
                n2 = n3;
            }
            n3 = this.probeNext(n3);
            v = this.values[n3];
        }
        return n2 != n;
    }

    private int calcMaxSize(int n) {
        int n2 = n - 1;
        return Math.min(n2, (int)((float)n * this.loadFactor));
    }

    private void rehash(int n) {
        byte[] byArray = this.keys;
        V[] VArray = this.values;
        this.keys = new byte[n];
        Object[] objectArray = new Object[n];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n);
        this.mask = n - 1;
        block0: for (int i = 0; i < VArray.length; ++i) {
            V v = VArray[i];
            if (v == null) continue;
            byte by = byArray[i];
            int n2 = this.hashIndex(by);
            while (true) {
                if (this.values[n2] == null) {
                    this.keys[n2] = by;
                    this.values[n2] = v;
                    continue block0;
                }
                n2 = this.probeNext(n2);
            }
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(4 * this.size);
        stringBuilder.append('{');
        boolean bl = true;
        for (int i = 0; i < this.values.length; ++i) {
            V v = this.values[i];
            if (v == null) continue;
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.keyToString(this.keys[i])).append('=').append((Object)(v == this ? "(this Map)" : ByteObjectHashMap.toExternal(v)));
            bl = false;
        }
        return stringBuilder.append('}').toString();
    }

    protected String keyToString(byte by) {
        return Byte.toString(by);
    }

    static /* synthetic */ int access$300(ByteObjectHashMap byteObjectHashMap) {
        return byteObjectHashMap.size;
    }

    static /* synthetic */ Set access$500(ByteObjectHashMap byteObjectHashMap) {
        return byteObjectHashMap.entrySet;
    }

    static /* synthetic */ Object[] access$600(ByteObjectHashMap byteObjectHashMap) {
        return byteObjectHashMap.values;
    }

    static /* synthetic */ boolean access$700(ByteObjectHashMap byteObjectHashMap, int n) {
        return byteObjectHashMap.removeAt(n);
    }

    static /* synthetic */ byte[] access$800(ByteObjectHashMap byteObjectHashMap) {
        return byteObjectHashMap.keys;
    }

    static /* synthetic */ Object access$900(Object object) {
        return ByteObjectHashMap.toExternal(object);
    }

    static /* synthetic */ Object access$1000(Object object) {
        return ByteObjectHashMap.toInternal(object);
    }
}

