/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util;

import java.lang.reflect.Constructor;
import pro.gravit.repackage.io.netty.util.ResourceLeakDetector;
import pro.gravit.repackage.io.netty.util.ResourceLeakDetectorFactory;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.SystemPropertyUtil;

final class ResourceLeakDetectorFactory$DefaultResourceLeakDetectorFactory
extends ResourceLeakDetectorFactory {
    private final Constructor<?> obsoleteCustomClassConstructor;
    private final Constructor<?> customClassConstructor;

    ResourceLeakDetectorFactory$DefaultResourceLeakDetectorFactory() {
        String string;
        try {
            string = SystemPropertyUtil.get("pro.gravit.repackage.io.netty.customResourceLeakDetector");
        }
        catch (Throwable throwable) {
            ResourceLeakDetectorFactory.access$000().error("Could not access System property: io.netty.customResourceLeakDetector", throwable);
            string = null;
        }
        if (string == null) {
            this.customClassConstructor = null;
            this.obsoleteCustomClassConstructor = null;
        } else {
            this.obsoleteCustomClassConstructor = ResourceLeakDetectorFactory$DefaultResourceLeakDetectorFactory.obsoleteCustomClassConstructor(string);
            this.customClassConstructor = ResourceLeakDetectorFactory$DefaultResourceLeakDetectorFactory.customClassConstructor(string);
        }
    }

    private static Constructor<?> obsoleteCustomClassConstructor(String string) {
        try {
            Class<?> clazz = Class.forName(string, true, PlatformDependent.getSystemClassLoader());
            if (ResourceLeakDetector.class.isAssignableFrom(clazz)) {
                return clazz.getConstructor(Class.class, Integer.TYPE, Long.TYPE);
            }
            ResourceLeakDetectorFactory.access$000().error("Class {} does not inherit from ResourceLeakDetector.", (Object)string);
        }
        catch (Throwable throwable) {
            ResourceLeakDetectorFactory.access$000().error("Could not load custom resource leak detector class provided: {}", (Object)string, (Object)throwable);
        }
        return null;
    }

    private static Constructor<?> customClassConstructor(String string) {
        try {
            Class<?> clazz = Class.forName(string, true, PlatformDependent.getSystemClassLoader());
            if (ResourceLeakDetector.class.isAssignableFrom(clazz)) {
                return clazz.getConstructor(Class.class, Integer.TYPE);
            }
            ResourceLeakDetectorFactory.access$000().error("Class {} does not inherit from ResourceLeakDetector.", (Object)string);
        }
        catch (Throwable throwable) {
            ResourceLeakDetectorFactory.access$000().error("Could not load custom resource leak detector class provided: {}", (Object)string, (Object)throwable);
        }
        return null;
    }

    @Override
    public <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> clazz, int n, long l) {
        if (this.obsoleteCustomClassConstructor != null) {
            try {
                ResourceLeakDetector resourceLeakDetector = (ResourceLeakDetector)this.obsoleteCustomClassConstructor.newInstance(clazz, n, l);
                ResourceLeakDetectorFactory.access$000().debug("Loaded custom ResourceLeakDetector: {}", (Object)this.obsoleteCustomClassConstructor.getDeclaringClass().getName());
                return resourceLeakDetector;
            }
            catch (Throwable throwable) {
                ResourceLeakDetectorFactory.access$000().error("Could not load custom resource leak detector provided: {} with the given resource: {}", this.obsoleteCustomClassConstructor.getDeclaringClass().getName(), clazz, throwable);
            }
        }
        ResourceLeakDetector resourceLeakDetector = new ResourceLeakDetector(clazz, n, l);
        ResourceLeakDetectorFactory.access$000().debug("Loaded default ResourceLeakDetector: {}", (Object)resourceLeakDetector);
        return resourceLeakDetector;
    }

    @Override
    public <T> ResourceLeakDetector<T> newResourceLeakDetector(Class<T> clazz, int n) {
        if (this.customClassConstructor != null) {
            try {
                ResourceLeakDetector resourceLeakDetector = (ResourceLeakDetector)this.customClassConstructor.newInstance(clazz, n);
                ResourceLeakDetectorFactory.access$000().debug("Loaded custom ResourceLeakDetector: {}", (Object)this.customClassConstructor.getDeclaringClass().getName());
                return resourceLeakDetector;
            }
            catch (Throwable throwable) {
                ResourceLeakDetectorFactory.access$000().error("Could not load custom resource leak detector provided: {} with the given resource: {}", this.customClassConstructor.getDeclaringClass().getName(), clazz, throwable);
            }
        }
        ResourceLeakDetector resourceLeakDetector = new ResourceLeakDetector(clazz, n);
        ResourceLeakDetectorFactory.access$000().debug("Loaded default ResourceLeakDetector: {}", (Object)resourceLeakDetector);
        return resourceLeakDetector;
    }
}

