/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.locks.Lock;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.handler.ssl.ApplicationProtocolAccessor;
import pro.gravit.repackage.io.netty.handler.ssl.ApplicationProtocolConfig$SelectedListenerFailureBehavior;
import pro.gravit.repackage.io.netty.handler.ssl.CipherSuiteConverter;
import pro.gravit.repackage.io.netty.handler.ssl.ClientAuth;
import pro.gravit.repackage.io.netty.handler.ssl.Java7SslParametersUtils;
import pro.gravit.repackage.io.netty.handler.ssl.Java8SslUtils;
import pro.gravit.repackage.io.netty.handler.ssl.NotSslRecordException;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSsl;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslEngineMap;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslKeyMaterial;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslSession;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslSessionId;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslEngine$1;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslEngine$2;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslEngine$AsyncTaskDecorator;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslEngine$DefaultOpenSslSession;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslEngine$HandshakeState;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslEngine$NativeSslException;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslEngine$OpenSslException;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslEngine$OpenSslHandshakeException;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslEngine$TaskDecorator;
import pro.gravit.repackage.io.netty.handler.ssl.SslUtils;
import pro.gravit.repackage.io.netty.internal.tcnative.AsyncTask;
import pro.gravit.repackage.io.netty.internal.tcnative.Buffer;
import pro.gravit.repackage.io.netty.internal.tcnative.SSL;
import pro.gravit.repackage.io.netty.util.AbstractReferenceCounted;
import pro.gravit.repackage.io.netty.util.ReferenceCounted;
import pro.gravit.repackage.io.netty.util.ResourceLeakDetector;
import pro.gravit.repackage.io.netty.util.ResourceLeakDetectorFactory;
import pro.gravit.repackage.io.netty.util.ResourceLeakTracker;
import pro.gravit.repackage.io.netty.util.internal.EmptyArrays;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.SuppressJava6Requirement;
import pro.gravit.repackage.io.netty.util.internal.ThrowableUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public class ReferenceCountedOpenSslEngine
extends SSLEngine
implements ApplicationProtocolAccessor,
ReferenceCounted {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountedOpenSslEngine.class);
    private static final ResourceLeakDetector<ReferenceCountedOpenSslEngine> leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(ReferenceCountedOpenSslEngine.class);
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_SSLV2 = 0;
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_SSLV3 = 1;
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_TLSv1 = 2;
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_TLSv1_1 = 3;
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_TLSv1_2 = 4;
    private static final int OPENSSL_OP_NO_PROTOCOL_INDEX_TLSv1_3 = 5;
    private static final int[] OPENSSL_OP_NO_PROTOCOLS = new int[]{SSL.SSL_OP_NO_SSLv2, SSL.SSL_OP_NO_SSLv3, SSL.SSL_OP_NO_TLSv1, SSL.SSL_OP_NO_TLSv1_1, SSL.SSL_OP_NO_TLSv1_2, SSL.SSL_OP_NO_TLSv1_3};
    static final int MAX_PLAINTEXT_LENGTH = SSL.SSL_MAX_PLAINTEXT_LENGTH;
    static final int MAX_RECORD_SIZE = SSL.SSL_MAX_RECORD_LENGTH;
    private static final SSLEngineResult NEED_UNWRAP_OK = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
    private static final SSLEngineResult NEED_UNWRAP_CLOSED = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_UNWRAP, 0, 0);
    private static final SSLEngineResult NEED_WRAP_OK = new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
    private static final SSLEngineResult NEED_WRAP_CLOSED = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, 0);
    private static final SSLEngineResult CLOSED_NOT_HANDSHAKING = new SSLEngineResult(SSLEngineResult.Status.CLOSED, SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
    private long ssl;
    private long networkBIO;
    private ReferenceCountedOpenSslEngine$HandshakeState handshakeState = ReferenceCountedOpenSslEngine$HandshakeState.NOT_STARTED;
    private boolean receivedShutdown;
    private volatile boolean destroyed;
    private volatile String applicationProtocol;
    private volatile boolean needTask;
    private String[] explicitlyEnabledProtocols;
    private boolean sessionSet;
    private final ResourceLeakTracker<ReferenceCountedOpenSslEngine> leak;
    private final AbstractReferenceCounted refCnt = new ReferenceCountedOpenSslEngine$1(this);
    private volatile ClientAuth clientAuth = ClientAuth.NONE;
    private volatile long lastAccessed = -1L;
    private String endPointIdentificationAlgorithm;
    private Object algorithmConstraints;
    private List<String> sniHostNames;
    private volatile Collection<?> matchers;
    private boolean isInboundDone;
    private boolean outboundClosed;
    final boolean jdkCompatibilityMode;
    private final boolean clientMode;
    final ByteBufAllocator alloc;
    private final OpenSslEngineMap engineMap;
    private final OpenSslApplicationProtocolNegotiator apn;
    private final ReferenceCountedOpenSslContext parentContext;
    private final OpenSslSession session;
    private final ByteBuffer[] singleSrcBuffer = new ByteBuffer[1];
    private final ByteBuffer[] singleDstBuffer = new ByteBuffer[1];
    private final boolean enableOcsp;
    private int maxWrapOverhead;
    private int maxWrapBufferSize;
    private Throwable pendingException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceCountedOpenSslEngine(ReferenceCountedOpenSslContext referenceCountedOpenSslContext, ByteBufAllocator byteBufAllocator, String string, int n, boolean bl, boolean bl2) {
        super(string, n);
        long l;
        OpenSsl.ensureAvailability();
        this.engineMap = referenceCountedOpenSslContext.engineMap;
        this.enableOcsp = referenceCountedOpenSslContext.enableOcsp;
        this.jdkCompatibilityMode = bl;
        this.alloc = ObjectUtil.checkNotNull(byteBufAllocator, "alloc");
        this.apn = (OpenSslApplicationProtocolNegotiator)referenceCountedOpenSslContext.applicationProtocolNegotiator();
        this.clientMode = referenceCountedOpenSslContext.isClient();
        this.session = PlatformDependent.javaVersion() >= 7 ? new ReferenceCountedOpenSslEngine$2(this, new ReferenceCountedOpenSslEngine$DefaultOpenSslSession(this, referenceCountedOpenSslContext.sessionContext())) : new ReferenceCountedOpenSslEngine$DefaultOpenSslSession(this, referenceCountedOpenSslContext.sessionContext());
        if (!referenceCountedOpenSslContext.sessionContext().useKeyManager()) {
            this.session.setLocalCertificate(referenceCountedOpenSslContext.keyCertChain);
        }
        Lock lock = referenceCountedOpenSslContext.ctxLock.readLock();
        lock.lock();
        try {
            l = SSL.newSSL((long)referenceCountedOpenSslContext.ctx, (!referenceCountedOpenSslContext.isClient() ? 1 : 0) != 0);
        }
        finally {
            lock.unlock();
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            this.ssl = l;
            try {
                this.networkBIO = SSL.bioNewByteBuffer((long)this.ssl, (int)referenceCountedOpenSslContext.getBioNonApplicationBufferSize());
                this.setClientAuth(this.clientMode ? ClientAuth.NONE : referenceCountedOpenSslContext.clientAuth);
                if (referenceCountedOpenSslContext.protocols != null) {
                    this.setEnabledProtocols0(referenceCountedOpenSslContext.protocols, true);
                } else {
                    this.explicitlyEnabledProtocols = this.getEnabledProtocols();
                }
                if (this.clientMode && SslUtils.isValidHostNameForSNI(string)) {
                    if (PlatformDependent.javaVersion() >= 8) {
                        if (Java8SslUtils.isValidHostNameForSNI(string)) {
                            SSL.setTlsExtHostName((long)this.ssl, (String)string);
                            this.sniHostNames = Collections.singletonList(string);
                        }
                    } else {
                        SSL.setTlsExtHostName((long)this.ssl, (String)string);
                        this.sniHostNames = Collections.singletonList(string);
                    }
                }
                if (this.enableOcsp) {
                    SSL.enableOcsp((long)this.ssl);
                }
                if (!bl) {
                    SSL.setMode((long)this.ssl, (int)(SSL.getMode((long)this.ssl) | SSL.SSL_MODE_ENABLE_PARTIAL_WRITE));
                }
                if (ReferenceCountedOpenSslEngine.isProtocolEnabled(SSL.getOptions((long)this.ssl), SSL.SSL_OP_NO_TLSv1_3, "TLSv1.3")) {
                    boolean bl3;
                    boolean bl4 = bl3 = this.clientMode ? ReferenceCountedOpenSslContext.CLIENT_ENABLE_SESSION_TICKET_TLSV13 : ReferenceCountedOpenSslContext.SERVER_ENABLE_SESSION_TICKET_TLSV13;
                    if (bl3) {
                        SSL.clearOptions((long)this.ssl, (int)SSL.SSL_OP_NO_TICKET);
                    }
                }
                if (OpenSsl.isBoringSSL() && this.clientMode) {
                    SSL.setRenegotiateMode((long)this.ssl, (int)SSL.SSL_RENEGOTIATE_ONCE);
                }
                this.calculateMaxWrapOverhead();
            }
            catch (Throwable throwable) {
                this.shutdown();
                PlatformDependent.throwException(throwable);
            }
        }
        this.parentContext = referenceCountedOpenSslContext;
        this.parentContext.retain();
        this.leak = bl2 ? leakDetector.track(this) : null;
    }

    final synchronized String[] authMethods() {
        if (this.isDestroyed()) {
            return EmptyArrays.EMPTY_STRINGS;
        }
        return SSL.authenticationMethods((long)this.ssl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean setKeyMaterial(OpenSslKeyMaterial openSslKeyMaterial) {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.isDestroyed()) {
                return false;
            }
            SSL.setKeyMaterial((long)this.ssl, (long)openSslKeyMaterial.certificateChainAddress(), (long)openSslKeyMaterial.privateKeyAddress());
        }
        this.session.setLocalCertificate(openSslKeyMaterial.certificateChain());
        return true;
    }

    final synchronized SecretKeySpec masterKey() {
        if (this.isDestroyed()) {
            return null;
        }
        return new SecretKeySpec(SSL.getMasterKey((long)this.ssl), "AES");
    }

    synchronized boolean isSessionReused() {
        if (this.isDestroyed()) {
            return false;
        }
        return SSL.isSessionReused((long)this.ssl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOcspResponse(byte[] byArray) {
        if (!this.enableOcsp) {
            throw new IllegalStateException("OCSP stapling is not enabled");
        }
        if (this.clientMode) {
            throw new IllegalStateException("Not a server SSLEngine");
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (!this.isDestroyed()) {
                SSL.setOcspResponse((long)this.ssl, (byte[])byArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getOcspResponse() {
        if (!this.enableOcsp) {
            throw new IllegalStateException("OCSP stapling is not enabled");
        }
        if (!this.clientMode) {
            throw new IllegalStateException("Not a client SSLEngine");
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.isDestroyed()) {
                return EmptyArrays.EMPTY_BYTES;
            }
            return SSL.getOcspResponse((long)this.ssl);
        }
    }

    @Override
    public final int refCnt() {
        return this.refCnt.refCnt();
    }

    @Override
    public final ReferenceCounted retain() {
        this.refCnt.retain();
        return this;
    }

    @Override
    public final ReferenceCounted retain(int n) {
        this.refCnt.retain(n);
        return this;
    }

    @Override
    public final ReferenceCounted touch() {
        this.refCnt.touch();
        return this;
    }

    @Override
    public final ReferenceCounted touch(Object object) {
        this.refCnt.touch(object);
        return this;
    }

    @Override
    public final boolean release() {
        return this.refCnt.release();
    }

    @Override
    public final boolean release(int n) {
        return this.refCnt.release(n);
    }

    @Override
    public String getApplicationProtocol() {
        return this.applicationProtocol;
    }

    @Override
    public String getHandshakeApplicationProtocol() {
        return this.applicationProtocol;
    }

    @Override
    public final synchronized SSLSession getHandshakeSession() {
        switch (this.handshakeState) {
            case NOT_STARTED: 
            case FINISHED: {
                return null;
            }
        }
        return this.session;
    }

    public final synchronized long sslPointer() {
        return this.ssl;
    }

    public final synchronized void shutdown() {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.engineMap != null) {
                this.engineMap.remove(this.ssl);
            }
            SSL.freeSSL((long)this.ssl);
            this.networkBIO = 0L;
            this.ssl = 0L;
            this.outboundClosed = true;
            this.isInboundDone = true;
        }
        SSL.clearError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writePlaintextData(ByteBuffer byteBuffer, int n) {
        int n2;
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        if (byteBuffer.isDirect()) {
            n2 = SSL.writeToSSL((long)this.ssl, (long)(ReferenceCountedOpenSslEngine.bufferAddress(byteBuffer) + (long)n3), (int)n);
            if (n2 > 0) {
                byteBuffer.position(n3 + n2);
            }
        } else {
            ByteBuf byteBuf = this.alloc.directBuffer(n);
            try {
                byteBuffer.limit(n3 + n);
                byteBuf.setBytes(0, byteBuffer);
                byteBuffer.limit(n4);
                n2 = SSL.writeToSSL((long)this.ssl, (long)OpenSsl.memoryAddress(byteBuf), (int)n);
                if (n2 > 0) {
                    byteBuffer.position(n3 + n2);
                } else {
                    byteBuffer.position(n3);
                }
            }
            finally {
                byteBuf.release();
            }
        }
        return n2;
    }

    synchronized void bioSetFd(int n) {
        if (!this.isDestroyed()) {
            SSL.bioSetFd((long)this.ssl, (int)n);
        }
    }

    private ByteBuf writeEncryptedData(ByteBuffer byteBuffer, int n) {
        int n2 = byteBuffer.position();
        if (byteBuffer.isDirect()) {
            SSL.bioSetByteBuffer((long)this.networkBIO, (long)(ReferenceCountedOpenSslEngine.bufferAddress(byteBuffer) + (long)n2), (int)n, (boolean)false);
        } else {
            ByteBuf byteBuf = this.alloc.directBuffer(n);
            try {
                int n3 = byteBuffer.limit();
                byteBuffer.limit(n2 + n);
                byteBuf.writeBytes(byteBuffer);
                byteBuffer.position(n2);
                byteBuffer.limit(n3);
                SSL.bioSetByteBuffer((long)this.networkBIO, (long)OpenSsl.memoryAddress(byteBuf), (int)n, (boolean)false);
                return byteBuf;
            }
            catch (Throwable throwable) {
                byteBuf.release();
                PlatformDependent.throwException(throwable);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readPlaintextData(ByteBuffer byteBuffer) {
        int n;
        int n2 = byteBuffer.position();
        if (byteBuffer.isDirect()) {
            n = SSL.readFromSSL((long)this.ssl, (long)(ReferenceCountedOpenSslEngine.bufferAddress(byteBuffer) + (long)n2), (int)(byteBuffer.limit() - n2));
            if (n > 0) {
                byteBuffer.position(n2 + n);
            }
        } else {
            int n3 = byteBuffer.limit();
            int n4 = Math.min(this.maxEncryptedPacketLength0(), n3 - n2);
            ByteBuf byteBuf = this.alloc.directBuffer(n4);
            try {
                n = SSL.readFromSSL((long)this.ssl, (long)OpenSsl.memoryAddress(byteBuf), (int)n4);
                if (n > 0) {
                    byteBuffer.limit(n2 + n);
                    byteBuf.getBytes(byteBuf.readerIndex(), byteBuffer);
                    byteBuffer.limit(n3);
                }
            }
            finally {
                byteBuf.release();
            }
        }
        return n;
    }

    final synchronized int maxWrapOverhead() {
        return this.maxWrapOverhead;
    }

    final synchronized int maxEncryptedPacketLength() {
        return this.maxEncryptedPacketLength0();
    }

    final int maxEncryptedPacketLength0() {
        return this.maxWrapOverhead + MAX_PLAINTEXT_LENGTH;
    }

    final int calculateMaxLengthForWrap(int n, int n2) {
        return (int)Math.min((long)this.maxWrapBufferSize, (long)n + (long)this.maxWrapOverhead * (long)n2);
    }

    final synchronized int sslPending() {
        return this.sslPending0();
    }

    private void calculateMaxWrapOverhead() {
        this.maxWrapOverhead = SSL.getMaxWrapOverhead((long)this.ssl);
        this.maxWrapBufferSize = this.jdkCompatibilityMode ? this.maxEncryptedPacketLength0() : this.maxEncryptedPacketLength0() << 4;
    }

    private int sslPending0() {
        return this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.FINISHED ? 0 : SSL.sslPending((long)this.ssl);
    }

    private boolean isBytesAvailableEnoughForWrap(int n, int n2, int n3) {
        return (long)n - (long)this.maxWrapOverhead * (long)n3 >= (long)n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final SSLEngineResult wrap(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer byteBuffer) {
        ObjectUtil.checkNotNullWithIAE(byteBufferArray, "srcs");
        ObjectUtil.checkNotNullWithIAE(byteBuffer, "dst");
        if (n >= byteBufferArray.length || n + n2 > byteBufferArray.length) {
            throw new IndexOutOfBoundsException("offset: " + n + ", length: " + n2 + " (expected: offset <= offset + length <= srcs.length (" + byteBufferArray.length + "))");
        }
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.isOutboundDone()) {
                return this.isInboundDone() || this.isDestroyed() ? CLOSED_NOT_HANDSHAKING : NEED_UNWRAP_CLOSED;
            }
            int n3 = 0;
            ByteBuf byteBuf = null;
            try {
                int n4;
                if (byteBuffer.isDirect()) {
                    SSL.bioSetByteBuffer((long)this.networkBIO, (long)(ReferenceCountedOpenSslEngine.bufferAddress(byteBuffer) + (long)byteBuffer.position()), (int)byteBuffer.remaining(), (boolean)true);
                } else {
                    byteBuf = this.alloc.directBuffer(byteBuffer.remaining());
                    SSL.bioSetByteBuffer((long)this.networkBIO, (long)OpenSsl.memoryAddress(byteBuf), (int)byteBuf.writableBytes(), (boolean)true);
                }
                int n5 = SSL.bioLengthByteBuffer((long)this.networkBIO);
                if (this.outboundClosed) {
                    if (!this.isBytesAvailableEnoughForWrap(byteBuffer.remaining(), 2, 1)) {
                        SSLEngineResult sSLEngineResult = new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), 0, 0);
                        return sSLEngineResult;
                    }
                    n3 = SSL.bioFlushByteBuffer((long)this.networkBIO);
                    if (n3 <= 0) {
                        SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, 0);
                        return sSLEngineResult;
                    }
                    if (!this.doSSLShutdown()) {
                        SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, 0, n3);
                        return sSLEngineResult;
                    }
                    n3 = n5 - SSL.bioLengthByteBuffer((long)this.networkBIO);
                    SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, n3);
                    return sSLEngineResult;
                }
                SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                ReferenceCountedOpenSslEngine$HandshakeState referenceCountedOpenSslEngine$HandshakeState = this.handshakeState;
                if (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
                    if (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.STARTED_EXPLICITLY) {
                        this.handshakeState = ReferenceCountedOpenSslEngine$HandshakeState.STARTED_IMPLICITLY;
                    }
                    n3 = SSL.bioFlushByteBuffer((long)this.networkBIO);
                    if (this.pendingException != null) {
                        if (n3 > 0) {
                            SSLEngineResult sSLEngineResult = this.newResult(SSLEngineResult.HandshakeStatus.NEED_WRAP, 0, n3);
                            return sSLEngineResult;
                        }
                        SSLEngineResult sSLEngineResult = this.newResult(this.handshakeException(), 0, 0);
                        return sSLEngineResult;
                    }
                    handshakeStatus = this.handshake();
                    n3 = n5 - SSL.bioLengthByteBuffer((long)this.networkBIO);
                    if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        SSLEngineResult sSLEngineResult = this.newResult(handshakeStatus, 0, n3);
                        return sSLEngineResult;
                    }
                    if (n3 > 0) {
                        SSLEngineResult sSLEngineResult = this.newResult(this.mayFinishHandshake(handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED ? (n3 == n5 ? SSLEngineResult.HandshakeStatus.NEED_WRAP : this.getHandshakeStatus(SSL.bioLengthNonApplication((long)this.networkBIO))) : SSLEngineResult.HandshakeStatus.FINISHED), 0, n3);
                        return sSLEngineResult;
                    }
                    if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                        SSLEngineResult sSLEngineResult = this.isOutboundDone() ? NEED_UNWRAP_CLOSED : NEED_UNWRAP_OK;
                        return sSLEngineResult;
                    }
                    if (this.outboundClosed) {
                        n3 = SSL.bioFlushByteBuffer((long)this.networkBIO);
                        SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(handshakeStatus, 0, n3);
                        return sSLEngineResult;
                    }
                }
                int n6 = n + n2;
                if (this.jdkCompatibilityMode || referenceCountedOpenSslEngine$HandshakeState != ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
                    n4 = 0;
                    for (int i = n; i < n6; ++i) {
                        ByteBuffer byteBuffer2 = byteBufferArray[i];
                        if (byteBuffer2 == null) {
                            throw new IllegalArgumentException("srcs[" + i + "] is null");
                        }
                        if (n4 == MAX_PLAINTEXT_LENGTH || (n4 += byteBuffer2.remaining()) <= MAX_PLAINTEXT_LENGTH && n4 >= 0) continue;
                        n4 = MAX_PLAINTEXT_LENGTH;
                    }
                    if (!this.isBytesAvailableEnoughForWrap(byteBuffer.remaining(), n4, 1)) {
                        SSLEngineResult sSLEngineResult = new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), 0, 0);
                        return sSLEngineResult;
                    }
                }
                n4 = 0;
                assert (n3 == 0);
                n3 = SSL.bioFlushByteBuffer((long)this.networkBIO);
                if (n3 > 0) {
                    SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(handshakeStatus, n4, n3);
                    return sSLEngineResult;
                }
                if (this.pendingException != null) {
                    Throwable throwable = this.pendingException;
                    this.pendingException = null;
                    this.shutdown();
                    throw new SSLException(throwable);
                }
                while (n < n6) {
                    ByteBuffer byteBuffer3 = byteBufferArray[n];
                    int n7 = byteBuffer3.remaining();
                    if (n7 != 0) {
                        int n8;
                        int n9;
                        if (this.jdkCompatibilityMode) {
                            n9 = this.writePlaintextData(byteBuffer3, Math.min(n7, MAX_PLAINTEXT_LENGTH - n4));
                        } else {
                            n8 = byteBuffer.remaining() - n3 - this.maxWrapOverhead;
                            if (n8 <= 0) {
                                SSLEngineResult sSLEngineResult = new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), n4, n3);
                                return sSLEngineResult;
                            }
                            n9 = this.writePlaintextData(byteBuffer3, Math.min(n7, n8));
                        }
                        n8 = SSL.bioLengthByteBuffer((long)this.networkBIO);
                        n3 += n5 - n8;
                        n5 = n8;
                        if (n9 > 0) {
                            n4 += n9;
                            if (this.jdkCompatibilityMode || n3 == byteBuffer.remaining()) {
                                SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(handshakeStatus, n4, n3);
                                return sSLEngineResult;
                            }
                        } else {
                            int n10 = SSL.getError((long)this.ssl, (int)n9);
                            if (n10 == SSL.SSL_ERROR_ZERO_RETURN) {
                                if (!this.receivedShutdown) {
                                    this.closeAll();
                                    SSLEngineResult.HandshakeStatus handshakeStatus2 = this.mayFinishHandshake(handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED ? ((n3 += n5 - SSL.bioLengthByteBuffer((long)this.networkBIO)) == byteBuffer.remaining() ? SSLEngineResult.HandshakeStatus.NEED_WRAP : this.getHandshakeStatus(SSL.bioLengthNonApplication((long)this.networkBIO))) : SSLEngineResult.HandshakeStatus.FINISHED);
                                    SSLEngineResult sSLEngineResult = this.newResult(handshakeStatus2, n4, n3);
                                    return sSLEngineResult;
                                }
                                SSLEngineResult sSLEngineResult = this.newResult(SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING, n4, n3);
                                return sSLEngineResult;
                            }
                            if (n10 == SSL.SSL_ERROR_WANT_READ) {
                                SSLEngineResult sSLEngineResult = this.newResult(SSLEngineResult.HandshakeStatus.NEED_UNWRAP, n4, n3);
                                return sSLEngineResult;
                            }
                            if (n10 == SSL.SSL_ERROR_WANT_WRITE) {
                                if (n3 > 0) {
                                    SSLEngineResult sSLEngineResult = this.newResult(SSLEngineResult.HandshakeStatus.NEED_WRAP, n4, n3);
                                    return sSLEngineResult;
                                }
                                SSLEngineResult sSLEngineResult = this.newResult(SSLEngineResult.Status.BUFFER_OVERFLOW, handshakeStatus, n4, n3);
                                return sSLEngineResult;
                            }
                            if (n10 != SSL.SSL_ERROR_WANT_X509_LOOKUP && n10 != SSL.SSL_ERROR_WANT_CERTIFICATE_VERIFY && n10 != SSL.SSL_ERROR_WANT_PRIVATE_KEY_OPERATION) {
                                throw this.shutdownWithError("SSL_write", n10);
                            }
                            SSLEngineResult sSLEngineResult = this.newResult(SSLEngineResult.HandshakeStatus.NEED_TASK, n4, n3);
                            return sSLEngineResult;
                        }
                    }
                    ++n;
                }
                SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(handshakeStatus, n4, n3);
                return sSLEngineResult;
            }
            finally {
                SSL.bioClearByteBuffer((long)this.networkBIO);
                if (byteBuf == null) {
                    byteBuffer.position(byteBuffer.position() + n3);
                } else {
                    assert (byteBuf.readableBytes() <= byteBuffer.remaining()) : "The destination buffer " + byteBuffer + " didn't have enough remaining space to hold the encrypted content in " + byteBuf;
                    byteBuffer.put(byteBuf.internalNioBuffer(byteBuf.readerIndex(), n3));
                    byteBuf.release();
                }
            }
        }
    }

    private SSLEngineResult newResult(SSLEngineResult.HandshakeStatus handshakeStatus, int n, int n2) {
        return this.newResult(SSLEngineResult.Status.OK, handshakeStatus, n, n2);
    }

    private SSLEngineResult newResult(SSLEngineResult.Status status, SSLEngineResult.HandshakeStatus handshakeStatus, int n, int n2) {
        if (this.isOutboundDone()) {
            if (this.isInboundDone()) {
                handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                this.shutdown();
            }
            return new SSLEngineResult(SSLEngineResult.Status.CLOSED, handshakeStatus, n, n2);
        }
        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            this.needTask = true;
        }
        return new SSLEngineResult(status, handshakeStatus, n, n2);
    }

    private SSLEngineResult newResultMayFinishHandshake(SSLEngineResult.HandshakeStatus handshakeStatus, int n, int n2) {
        return this.newResult(this.mayFinishHandshake(handshakeStatus, n, n2), n, n2);
    }

    private SSLEngineResult newResultMayFinishHandshake(SSLEngineResult.Status status, SSLEngineResult.HandshakeStatus handshakeStatus, int n, int n2) {
        return this.newResult(status, this.mayFinishHandshake(handshakeStatus, n, n2), n, n2);
    }

    private SSLException shutdownWithError(String string, int n) {
        return this.shutdownWithError(string, n, SSL.getLastErrorNumber());
    }

    private SSLException shutdownWithError(String string, int n, int n2) {
        Object object;
        if (logger.isDebugEnabled()) {
            object = SSL.getErrorString((long)n2);
            logger.debug("{} failed with {}: OpenSSL error: {} {}", string, n, n2, object);
        }
        this.shutdown();
        object = this.newSSLExceptionForError(n2);
        if (this.pendingException != null) {
            ((Throwable)object).initCause(this.pendingException);
            this.pendingException = null;
        }
        return object;
    }

    private SSLEngineResult handleUnwrapException(int n, int n2, SSLException sSLException) {
        int n3 = SSL.getLastErrorNumber();
        if (n3 != 0) {
            return this.sslReadErrorResult(SSL.SSL_ERROR_SSL, n3, n, n2);
        }
        throw sSLException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final SSLEngineResult unwrap(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer[] byteBufferArray2, int n3, int n4) {
        Object object;
        int n5;
        ByteBuffer byteBuffer;
        ObjectUtil.checkNotNullWithIAE(byteBufferArray, "srcs");
        if (n >= byteBufferArray.length || n + n2 > byteBufferArray.length) {
            throw new IndexOutOfBoundsException("offset: " + n + ", length: " + n2 + " (expected: offset <= offset + length <= srcs.length (" + byteBufferArray.length + "))");
        }
        ObjectUtil.checkNotNullWithIAE(byteBufferArray2, "dsts");
        if (n3 >= byteBufferArray2.length || n3 + n4 > byteBufferArray2.length) {
            throw new IndexOutOfBoundsException("offset: " + n3 + ", length: " + n4 + " (expected: offset <= offset + length <= dsts.length (" + byteBufferArray2.length + "))");
        }
        long l = 0L;
        int n6 = n3 + n4;
        for (n5 = n3; n5 < n6; l += (long)byteBuffer.remaining(), ++n5) {
            byteBuffer = ObjectUtil.checkNotNullArrayParam(byteBufferArray2[n5], n5, "dsts");
            if (!byteBuffer.isReadOnly()) continue;
            throw new ReadOnlyBufferException();
        }
        n5 = n + n2;
        long l2 = 0L;
        for (int i = n; i < n5; l2 += (long)object.remaining(), ++i) {
            object = ObjectUtil.checkNotNullArrayParam(byteBufferArray[i], i, "srcs");
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            int n7;
            int n8;
            block59: {
                int n9;
                if (this.isInboundDone()) {
                    return this.isOutboundDone() || this.isDestroyed() ? CLOSED_NOT_HANDSHAKING : NEED_WRAP_CLOSED;
                }
                object = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                ReferenceCountedOpenSslEngine$HandshakeState referenceCountedOpenSslEngine$HandshakeState = this.handshakeState;
                if (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
                    if (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.STARTED_EXPLICITLY) {
                        this.handshakeState = ReferenceCountedOpenSslEngine$HandshakeState.STARTED_IMPLICITLY;
                    }
                    if ((object = this.handshake()) == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        return this.newResult((SSLEngineResult.HandshakeStatus)((Object)object), 0, 0);
                    }
                    if (object == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                        return NEED_WRAP_OK;
                    }
                    if (this.isInboundDone) {
                        return NEED_WRAP_CLOSED;
                    }
                }
                int n10 = this.sslPending0();
                if (this.jdkCompatibilityMode || referenceCountedOpenSslEngine$HandshakeState != ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
                    if (l2 < 5L) {
                        return this.newResultMayFinishHandshake(SSLEngineResult.Status.BUFFER_UNDERFLOW, (SSLEngineResult.HandshakeStatus)((Object)object), 0, 0);
                    }
                    n9 = SslUtils.getEncryptedPacketLength(byteBufferArray, n);
                    if (n9 == -2) {
                        throw new NotSslRecordException("not an SSL/TLS record");
                    }
                    n8 = n9 - 5;
                    if ((long)n8 > l) {
                        if (n8 > MAX_RECORD_SIZE) {
                            throw new SSLException("Illegal packet length: " + n8 + " > " + this.session.getApplicationBufferSize());
                        }
                        this.session.tryExpandApplicationBufferSize(n8);
                        return this.newResultMayFinishHandshake(SSLEngineResult.Status.BUFFER_OVERFLOW, (SSLEngineResult.HandshakeStatus)((Object)object), 0, 0);
                    }
                    if (l2 < (long)n9) {
                        return this.newResultMayFinishHandshake(SSLEngineResult.Status.BUFFER_UNDERFLOW, (SSLEngineResult.HandshakeStatus)((Object)object), 0, 0);
                    }
                } else {
                    if (l2 == 0L && n10 <= 0) {
                        return this.newResultMayFinishHandshake(SSLEngineResult.Status.BUFFER_UNDERFLOW, (SSLEngineResult.HandshakeStatus)((Object)object), 0, 0);
                    }
                    if (l == 0L) {
                        return this.newResultMayFinishHandshake(SSLEngineResult.Status.BUFFER_OVERFLOW, (SSLEngineResult.HandshakeStatus)((Object)object), 0, 0);
                    }
                    n9 = (int)Math.min(Integer.MAX_VALUE, l2);
                }
                assert (n < n5);
                assert (l > 0L);
                n8 = 0;
                n7 = 0;
                try {
                    while (true) {
                        int n11;
                        ByteBuf byteBuf;
                        ByteBuffer byteBuffer2;
                        int n12;
                        if ((n12 = (byteBuffer2 = byteBufferArray[n]).remaining()) == 0) {
                            if (n10 <= 0) {
                                if (++n < n5) continue;
                                break;
                            }
                            byteBuf = null;
                            n11 = SSL.bioLengthByteBuffer((long)this.networkBIO);
                        } else {
                            n11 = Math.min(n9, n12);
                            try {
                                byteBuf = this.writeEncryptedData(byteBuffer2, n11);
                            }
                            catch (SSLException sSLException) {
                                SSLEngineResult sSLEngineResult = this.handleUnwrapException(n7, n8, sSLException);
                                SSL.bioClearByteBuffer((long)this.networkBIO);
                                this.rejectRemoteInitiatedRenegotiation();
                                return sSLEngineResult;
                            }
                        }
                        try {
                            int n13;
                            block60: {
                                while (true) {
                                    ByteBuffer byteBuffer3;
                                    if (!(byteBuffer3 = byteBufferArray2[n3]).hasRemaining()) {
                                        if (++n3 < n6) continue;
                                        break block59;
                                    }
                                    try {
                                        n13 = this.readPlaintextData(byteBuffer3);
                                    }
                                    catch (SSLException sSLException) {
                                        SSLEngineResult sSLEngineResult = this.handleUnwrapException(n7, n8, sSLException);
                                        if (byteBuf != null) {
                                            byteBuf.release();
                                        }
                                        SSL.bioClearByteBuffer((long)this.networkBIO);
                                        this.rejectRemoteInitiatedRenegotiation();
                                        return sSLEngineResult;
                                    }
                                    int n14 = n11 - SSL.bioLengthByteBuffer((long)this.networkBIO);
                                    n7 += n14;
                                    n9 -= n14;
                                    n11 -= n14;
                                    byteBuffer2.position(byteBuffer2.position() + n14);
                                    if (n13 <= 0) break block60;
                                    n8 += n13;
                                    if (!byteBuffer3.hasRemaining()) {
                                        n10 = this.sslPending0();
                                        if (++n3 < n6) continue;
                                        SSLEngineResult sSLEngineResult = n10 > 0 ? this.newResult(SSLEngineResult.Status.BUFFER_OVERFLOW, (SSLEngineResult.HandshakeStatus)((Object)object), n7, n8) : this.newResultMayFinishHandshake(this.isInboundDone() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK, (SSLEngineResult.HandshakeStatus)((Object)object), n7, n8);
                                        return sSLEngineResult;
                                    }
                                    if (n9 == 0 || this.jdkCompatibilityMode) break;
                                }
                                break;
                            }
                            int n15 = SSL.getError((long)this.ssl, (int)n13);
                            if (n15 != SSL.SSL_ERROR_WANT_READ && n15 != SSL.SSL_ERROR_WANT_WRITE) {
                                if (n15 == SSL.SSL_ERROR_ZERO_RETURN) {
                                    if (!this.receivedShutdown) {
                                        this.closeAll();
                                    }
                                    SSLEngineResult sSLEngineResult = this.newResultMayFinishHandshake(this.isInboundDone() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK, (SSLEngineResult.HandshakeStatus)((Object)object), n7, n8);
                                    return sSLEngineResult;
                                }
                                if (n15 == SSL.SSL_ERROR_WANT_X509_LOOKUP || n15 == SSL.SSL_ERROR_WANT_CERTIFICATE_VERIFY || n15 == SSL.SSL_ERROR_WANT_PRIVATE_KEY_OPERATION) {
                                    SSLEngineResult sSLEngineResult = this.newResult(this.isInboundDone() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_TASK, n7, n8);
                                    return sSLEngineResult;
                                }
                                SSLEngineResult sSLEngineResult = this.sslReadErrorResult(n15, SSL.getLastErrorNumber(), n7, n8);
                                return sSLEngineResult;
                            }
                            if (++n < n5) continue;
                        }
                        finally {
                            if (byteBuf == null) continue;
                            byteBuf.release();
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    SSL.bioClearByteBuffer((long)this.networkBIO);
                    this.rejectRemoteInitiatedRenegotiation();
                }
            }
            if (!this.receivedShutdown && (SSL.getShutdown((long)this.ssl) & SSL.SSL_RECEIVED_SHUTDOWN) == SSL.SSL_RECEIVED_SHUTDOWN) {
                this.closeAll();
            }
            return this.newResultMayFinishHandshake(this.isInboundDone() ? SSLEngineResult.Status.CLOSED : SSLEngineResult.Status.OK, (SSLEngineResult.HandshakeStatus)((Object)object), n7, n8);
        }
    }

    private boolean needWrapAgain(int n) {
        if (SSL.bioLengthNonApplication((long)this.networkBIO) > 0) {
            if (this.pendingException == null) {
                this.pendingException = this.newSSLExceptionForError(n);
            } else if (ReferenceCountedOpenSslEngine.shouldAddSuppressed(this.pendingException, n)) {
                ThrowableUtil.addSuppressed(this.pendingException, this.newSSLExceptionForError(n));
            }
            SSL.clearError();
            return true;
        }
        return false;
    }

    private SSLException newSSLExceptionForError(int n) {
        String string = SSL.getErrorString((long)n);
        return this.handshakeState == ReferenceCountedOpenSslEngine$HandshakeState.FINISHED ? new ReferenceCountedOpenSslEngine$OpenSslException(string, n) : new ReferenceCountedOpenSslEngine$OpenSslHandshakeException(string, n);
    }

    private static boolean shouldAddSuppressed(Throwable throwable, int n) {
        for (Throwable throwable2 : ThrowableUtil.getSuppressed(throwable)) {
            if (!(throwable2 instanceof ReferenceCountedOpenSslEngine$NativeSslException) || ((ReferenceCountedOpenSslEngine$NativeSslException)((Object)throwable2)).errorCode() != n) continue;
            return false;
        }
        return true;
    }

    private SSLEngineResult sslReadErrorResult(int n, int n2, int n3, int n4) {
        if (this.needWrapAgain(n2)) {
            return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, n3, n4);
        }
        throw this.shutdownWithError("SSL_read", n, n2);
    }

    private void closeAll() {
        this.receivedShutdown = true;
        this.closeOutbound();
        this.closeInbound();
    }

    private void rejectRemoteInitiatedRenegotiation() {
        if (!this.isDestroyed() && (!this.clientMode && SSL.getHandshakeCount((long)this.ssl) > 1 || this.clientMode && SSL.getHandshakeCount((long)this.ssl) > 2) && !"TLSv1.3".equals(this.session.getProtocol()) && this.handshakeState == ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
            this.shutdown();
            throw new SSLHandshakeException("remote-initiated renegotiation not allowed");
        }
    }

    public final SSLEngineResult unwrap(ByteBuffer[] byteBufferArray, ByteBuffer[] byteBufferArray2) {
        return this.unwrap(byteBufferArray, 0, byteBufferArray.length, byteBufferArray2, 0, byteBufferArray2.length);
    }

    private ByteBuffer[] singleSrcBuffer(ByteBuffer byteBuffer) {
        this.singleSrcBuffer[0] = byteBuffer;
        return this.singleSrcBuffer;
    }

    private void resetSingleSrcBuffer() {
        this.singleSrcBuffer[0] = null;
    }

    private ByteBuffer[] singleDstBuffer(ByteBuffer byteBuffer) {
        this.singleDstBuffer[0] = byteBuffer;
        return this.singleDstBuffer;
    }

    private void resetSingleDstBuffer() {
        this.singleDstBuffer[0] = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, int n, int n2) {
        try {
            SSLEngineResult sSLEngineResult = this.unwrap(this.singleSrcBuffer(byteBuffer), 0, 1, byteBufferArray, n, n2);
            return sSLEngineResult;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized SSLEngineResult wrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        try {
            SSLEngineResult sSLEngineResult = this.wrap(this.singleSrcBuffer(byteBuffer), byteBuffer2);
            return sSLEngineResult;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        try {
            SSLEngineResult sSLEngineResult = this.unwrap(this.singleSrcBuffer(byteBuffer), this.singleDstBuffer(byteBuffer2));
            return sSLEngineResult;
        }
        finally {
            this.resetSingleSrcBuffer();
            this.resetSingleDstBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray) {
        try {
            SSLEngineResult sSLEngineResult = this.unwrap(this.singleSrcBuffer(byteBuffer), byteBufferArray);
            return sSLEngineResult;
        }
        finally {
            this.resetSingleSrcBuffer();
        }
    }

    private synchronized void runAndResetNeedTask(Runnable runnable) {
        try {
            if (this.isDestroyed()) {
                return;
            }
            runnable.run();
        }
        finally {
            this.needTask = false;
        }
    }

    @Override
    public final synchronized Runnable getDelegatedTask() {
        if (this.isDestroyed()) {
            return null;
        }
        Runnable runnable = SSL.getTask((long)this.ssl);
        if (runnable == null) {
            return null;
        }
        if (runnable instanceof AsyncTask) {
            return new ReferenceCountedOpenSslEngine$AsyncTaskDecorator(this, (AsyncTask)runnable);
        }
        return new ReferenceCountedOpenSslEngine$TaskDecorator(this, runnable);
    }

    @Override
    public final synchronized void closeInbound() {
        if (this.isInboundDone) {
            return;
        }
        this.isInboundDone = true;
        if (this.isOutboundDone()) {
            this.shutdown();
        }
        if (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.NOT_STARTED && !this.receivedShutdown) {
            throw new SSLException("Inbound closed before receiving peer's close_notify: possible truncation attack?");
        }
    }

    @Override
    public final synchronized boolean isInboundDone() {
        return this.isInboundDone;
    }

    @Override
    public final synchronized void closeOutbound() {
        if (this.outboundClosed) {
            return;
        }
        this.outboundClosed = true;
        if (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.NOT_STARTED && !this.isDestroyed()) {
            int n = SSL.getShutdown((long)this.ssl);
            if ((n & SSL.SSL_SENT_SHUTDOWN) != SSL.SSL_SENT_SHUTDOWN) {
                this.doSSLShutdown();
            }
        } else {
            this.shutdown();
        }
    }

    private boolean doSSLShutdown() {
        if (SSL.isInInit((long)this.ssl) != 0) {
            return false;
        }
        int n = SSL.shutdownSSL((long)this.ssl);
        if (n < 0) {
            int n2 = SSL.getError((long)this.ssl, (int)n);
            if (n2 == SSL.SSL_ERROR_SYSCALL || n2 == SSL.SSL_ERROR_SSL) {
                if (logger.isDebugEnabled()) {
                    int n3 = SSL.getLastErrorNumber();
                    logger.debug("SSL_shutdown failed: OpenSSL error: {} {}", (Object)n3, (Object)SSL.getErrorString((long)n3));
                }
                this.shutdown();
                return false;
            }
            SSL.clearError();
        }
        return true;
    }

    @Override
    public final synchronized boolean isOutboundDone() {
        return this.outboundClosed && (this.networkBIO == 0L || SSL.bioLengthNonApplication((long)this.networkBIO) == 0);
    }

    @Override
    public final String[] getSupportedCipherSuites() {
        return OpenSsl.AVAILABLE_CIPHER_SUITES.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String[] getEnabledCipherSuites() {
        boolean bl;
        String[] stringArray;
        String[] stringArray2;
        Object object = this;
        synchronized (object) {
            if (!this.isDestroyed()) {
                stringArray2 = SSL.getCiphers((long)this.ssl);
                int n = SSL.getOptions((long)this.ssl);
                if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n, SSL.SSL_OP_NO_TLSv1_3, "TLSv1.3")) {
                    stringArray = OpenSsl.EXTRA_SUPPORTED_TLS_1_3_CIPHERS;
                    bl = true;
                } else {
                    stringArray = EmptyArrays.EMPTY_STRINGS;
                    bl = false;
                }
            } else {
                return EmptyArrays.EMPTY_STRINGS;
            }
        }
        if (stringArray2 == null) {
            return EmptyArrays.EMPTY_STRINGS;
        }
        object = new LinkedHashSet(stringArray2.length + stringArray.length);
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            for (int i = 0; i < stringArray2.length; ++i) {
                String string;
                String string2 = this.toJavaCipherSuite(stringArray2[i]);
                String string3 = string = string2 == null ? stringArray2[i] : string2;
                if ((!bl || !OpenSsl.isTlsv13Supported()) && SslUtils.isTLSv13Cipher(string)) continue;
                object.add(string);
            }
            Collections.addAll(object, stringArray);
        }
        return object.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setEnabledCipherSuites(String[] stringArray) {
        ObjectUtil.checkNotNull(stringArray, "cipherSuites");
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        CipherSuiteConverter.convertToCipherStrings(Arrays.asList(stringArray), stringBuilder, stringBuilder2, OpenSsl.isBoringSSL());
        String string = stringBuilder.toString();
        String string2 = stringBuilder2.toString();
        if (!OpenSsl.isTlsv13Supported() && !string2.isEmpty()) {
            throw new IllegalArgumentException("TLSv1.3 is not supported by this java version.");
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (!this.isDestroyed()) {
                try {
                    SSL.setCipherSuites((long)this.ssl, (String)string, (boolean)false);
                    if (OpenSsl.isTlsv13Supported()) {
                        SSL.setCipherSuites((long)this.ssl, (String)OpenSsl.checkTls13Ciphers(logger, string2), (boolean)true);
                    }
                    HashSet hashSet = new HashSet(this.explicitlyEnabledProtocols.length);
                    Collections.addAll(hashSet, this.explicitlyEnabledProtocols);
                    if (string.isEmpty()) {
                        hashSet.remove("TLSv1");
                        hashSet.remove("TLSv1.1");
                        hashSet.remove("TLSv1.2");
                        hashSet.remove("SSLv3");
                        hashSet.remove("SSLv2");
                        hashSet.remove("SSLv2Hello");
                    }
                    if (string2.isEmpty()) {
                        hashSet.remove("TLSv1.3");
                    }
                    this.setEnabledProtocols0(hashSet.toArray(EmptyArrays.EMPTY_STRINGS), false);
                }
                catch (Exception exception) {
                    throw new IllegalStateException("failed to enable cipher suites: " + string, exception);
                }
            } else {
                throw new IllegalStateException("failed to enable cipher suites: " + string);
            }
        }
    }

    @Override
    public final String[] getSupportedProtocols() {
        return OpenSsl.SUPPORTED_PROTOCOLS_SET.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String[] getEnabledProtocols() {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>(6);
        arrayList.add("SSLv2Hello");
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.isDestroyed()) {
                return arrayList.toArray(new String[0]);
            }
            n = SSL.getOptions((long)this.ssl);
        }
        if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n, SSL.SSL_OP_NO_TLSv1, "TLSv1")) {
            arrayList.add("TLSv1");
        }
        if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n, SSL.SSL_OP_NO_TLSv1_1, "TLSv1.1")) {
            arrayList.add("TLSv1.1");
        }
        if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n, SSL.SSL_OP_NO_TLSv1_2, "TLSv1.2")) {
            arrayList.add("TLSv1.2");
        }
        if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n, SSL.SSL_OP_NO_TLSv1_3, "TLSv1.3")) {
            arrayList.add("TLSv1.3");
        }
        if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n, SSL.SSL_OP_NO_SSLv2, "SSLv2")) {
            arrayList.add("SSLv2");
        }
        if (ReferenceCountedOpenSslEngine.isProtocolEnabled(n, SSL.SSL_OP_NO_SSLv3, "SSLv3")) {
            arrayList.add("SSLv3");
        }
        return arrayList.toArray(new String[0]);
    }

    private static boolean isProtocolEnabled(int n, int n2, String string) {
        return (n & n2) == 0 && OpenSsl.SUPPORTED_PROTOCOLS_SET.contains(string);
    }

    @Override
    public final void setEnabledProtocols(String[] stringArray) {
        this.setEnabledProtocols0(stringArray, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnabledProtocols0(String[] stringArray, boolean bl) {
        ObjectUtil.checkNotNullWithIAE(stringArray, "protocols");
        int n = OPENSSL_OP_NO_PROTOCOLS.length;
        int n2 = 0;
        for (String string : stringArray) {
            if (!OpenSsl.SUPPORTED_PROTOCOLS_SET.contains(string)) {
                throw new IllegalArgumentException("Protocol " + string + " is not supported.");
            }
            if (string.equals("SSLv2")) {
                if (n > 0) {
                    n = 0;
                }
                if (n2 >= 0) continue;
                n2 = 0;
                continue;
            }
            if (string.equals("SSLv3")) {
                if (n > 1) {
                    n = 1;
                }
                if (n2 >= 1) continue;
                n2 = 1;
                continue;
            }
            if (string.equals("TLSv1")) {
                if (n > 2) {
                    n = 2;
                }
                if (n2 >= 2) continue;
                n2 = 2;
                continue;
            }
            if (string.equals("TLSv1.1")) {
                if (n > 3) {
                    n = 3;
                }
                if (n2 >= 3) continue;
                n2 = 3;
                continue;
            }
            if (string.equals("TLSv1.2")) {
                if (n > 4) {
                    n = 4;
                }
                if (n2 >= 4) continue;
                n2 = 4;
                continue;
            }
            if (!string.equals("TLSv1.3")) continue;
            if (n > 5) {
                n = 5;
            }
            if (n2 >= 5) continue;
            n2 = 5;
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            int n3;
            if (bl) {
                this.explicitlyEnabledProtocols = stringArray;
            }
            if (!this.isDestroyed()) {
                int n4;
                SSL.clearOptions((long)this.ssl, (int)(SSL.SSL_OP_NO_SSLv2 | SSL.SSL_OP_NO_SSLv3 | SSL.SSL_OP_NO_TLSv1 | SSL.SSL_OP_NO_TLSv1_1 | SSL.SSL_OP_NO_TLSv1_2 | SSL.SSL_OP_NO_TLSv1_3));
                n3 = 0;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 |= OPENSSL_OP_NO_PROTOCOLS[n4];
                }
                assert (n2 != Integer.MAX_VALUE);
                for (n4 = n2 + 1; n4 < OPENSSL_OP_NO_PROTOCOLS.length; ++n4) {
                    n3 |= OPENSSL_OP_NO_PROTOCOLS[n4];
                }
            } else {
                throw new IllegalStateException("failed to enable protocols: " + Arrays.asList(stringArray));
            }
            SSL.setOptions((long)this.ssl, (int)n3);
        }
    }

    @Override
    public final SSLSession getSession() {
        return this.session;
    }

    @Override
    public final synchronized void beginHandshake() {
        switch (this.handshakeState) {
            case STARTED_IMPLICITLY: {
                this.checkEngineClosed();
                this.handshakeState = ReferenceCountedOpenSslEngine$HandshakeState.STARTED_EXPLICITLY;
                this.calculateMaxWrapOverhead();
                break;
            }
            case STARTED_EXPLICITLY: {
                break;
            }
            case FINISHED: {
                throw new SSLException("renegotiation unsupported");
            }
            case NOT_STARTED: {
                this.handshakeState = ReferenceCountedOpenSslEngine$HandshakeState.STARTED_EXPLICITLY;
                if (this.handshake() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.needTask = true;
                }
                this.calculateMaxWrapOverhead();
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    private void checkEngineClosed() {
        if (this.isDestroyed()) {
            throw new SSLException("engine closed");
        }
    }

    private static SSLEngineResult.HandshakeStatus pendingStatus(int n) {
        return n > 0 ? SSLEngineResult.HandshakeStatus.NEED_WRAP : SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
    }

    private static boolean isEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    private static boolean isEmpty(byte[] byArray) {
        return byArray == null || byArray.length == 0;
    }

    private SSLEngineResult.HandshakeStatus handshakeException() {
        if (SSL.bioLengthNonApplication((long)this.networkBIO) > 0) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        Throwable throwable = this.pendingException;
        assert (throwable != null);
        this.pendingException = null;
        this.shutdown();
        if (throwable instanceof SSLHandshakeException) {
            throw (SSLHandshakeException)throwable;
        }
        SSLHandshakeException sSLHandshakeException = new SSLHandshakeException("General OpenSslEngine problem");
        sSLHandshakeException.initCause(throwable);
        throw sSLHandshakeException;
    }

    final void initHandshakeException(Throwable throwable) {
        if (this.pendingException == null) {
            this.pendingException = throwable;
        } else {
            ThrowableUtil.addSuppressed(this.pendingException, throwable);
        }
    }

    private SSLEngineResult.HandshakeStatus handshake() {
        int n;
        if (this.needTask) {
            return SSLEngineResult.HandshakeStatus.NEED_TASK;
        }
        if (this.handshakeState == ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
            return SSLEngineResult.HandshakeStatus.FINISHED;
        }
        this.checkEngineClosed();
        if (this.pendingException != null) {
            if (SSL.doHandshake((long)this.ssl) <= 0) {
                SSL.clearError();
            }
            return this.handshakeException();
        }
        this.engineMap.add(this);
        if (!this.sessionSet) {
            this.parentContext.sessionContext().setSessionFromCache(this.getPeerHost(), this.getPeerPort(), this.ssl);
            this.sessionSet = true;
        }
        if (this.lastAccessed == -1L) {
            this.lastAccessed = System.currentTimeMillis();
        }
        if ((n = SSL.doHandshake((long)this.ssl)) <= 0) {
            int n2 = SSL.getError((long)this.ssl, (int)n);
            if (n2 == SSL.SSL_ERROR_WANT_READ || n2 == SSL.SSL_ERROR_WANT_WRITE) {
                return ReferenceCountedOpenSslEngine.pendingStatus(SSL.bioLengthNonApplication((long)this.networkBIO));
            }
            if (n2 == SSL.SSL_ERROR_WANT_X509_LOOKUP || n2 == SSL.SSL_ERROR_WANT_CERTIFICATE_VERIFY || n2 == SSL.SSL_ERROR_WANT_PRIVATE_KEY_OPERATION) {
                return SSLEngineResult.HandshakeStatus.NEED_TASK;
            }
            if (this.needWrapAgain(SSL.getLastErrorNumber())) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
            if (this.pendingException != null) {
                return this.handshakeException();
            }
            throw this.shutdownWithError("SSL_do_handshake", n2);
        }
        if (SSL.bioLengthNonApplication((long)this.networkBIO) > 0) {
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        this.session.handshakeFinished(SSL.getSessionId((long)this.ssl), SSL.getCipherForSSL((long)this.ssl), SSL.getVersion((long)this.ssl), SSL.getPeerCertificate((long)this.ssl), SSL.getPeerCertChain((long)this.ssl), SSL.getTime((long)this.ssl) * 1000L, this.parentContext.sessionTimeout() * 1000L);
        this.selectApplicationProtocol();
        return SSLEngineResult.HandshakeStatus.FINISHED;
    }

    private SSLEngineResult.HandshakeStatus mayFinishHandshake(SSLEngineResult.HandshakeStatus handshakeStatus, int n, int n2) {
        return handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP && n2 > 0 || handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP && n > 0 ? this.handshake() : this.mayFinishHandshake(handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED ? this.getHandshakeStatus() : SSLEngineResult.HandshakeStatus.FINISHED);
    }

    private SSLEngineResult.HandshakeStatus mayFinishHandshake(SSLEngineResult.HandshakeStatus handshakeStatus) {
        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            if (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.FINISHED) {
                return this.handshake();
            }
            if (!this.isDestroyed() && SSL.bioLengthNonApplication((long)this.networkBIO) > 0) {
                return SSLEngineResult.HandshakeStatus.NEED_WRAP;
            }
        }
        return handshakeStatus;
    }

    @Override
    public final synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        if (this.needPendingStatus()) {
            if (this.needTask) {
                return SSLEngineResult.HandshakeStatus.NEED_TASK;
            }
            return ReferenceCountedOpenSslEngine.pendingStatus(SSL.bioLengthNonApplication((long)this.networkBIO));
        }
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    private SSLEngineResult.HandshakeStatus getHandshakeStatus(int n) {
        if (this.needPendingStatus()) {
            if (this.needTask) {
                return SSLEngineResult.HandshakeStatus.NEED_TASK;
            }
            return ReferenceCountedOpenSslEngine.pendingStatus(n);
        }
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    private boolean needPendingStatus() {
        return this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.NOT_STARTED && !this.isDestroyed() && (this.handshakeState != ReferenceCountedOpenSslEngine$HandshakeState.FINISHED || this.isInboundDone() || this.isOutboundDone());
    }

    private String toJavaCipherSuite(String string) {
        if (string == null) {
            return null;
        }
        String string2 = SSL.getVersion((long)this.ssl);
        String string3 = ReferenceCountedOpenSslEngine.toJavaCipherSuitePrefix(string2);
        return CipherSuiteConverter.toJava(string, string3);
    }

    private static String toJavaCipherSuitePrefix(String string) {
        int n = string == null || string.isEmpty() ? 0 : (int)string.charAt(0);
        switch (n) {
            case 84: {
                return "TLS";
            }
            case 83: {
                return "SSL";
            }
        }
        return "UNKNOWN";
    }

    @Override
    public final void setUseClientMode(boolean bl) {
        if (bl != this.clientMode) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public final boolean getUseClientMode() {
        return this.clientMode;
    }

    @Override
    public final void setNeedClientAuth(boolean bl) {
        this.setClientAuth(bl ? ClientAuth.REQUIRE : ClientAuth.NONE);
    }

    @Override
    public final boolean getNeedClientAuth() {
        return this.clientAuth == ClientAuth.REQUIRE;
    }

    @Override
    public final void setWantClientAuth(boolean bl) {
        this.setClientAuth(bl ? ClientAuth.OPTIONAL : ClientAuth.NONE);
    }

    @Override
    public final boolean getWantClientAuth() {
        return this.clientAuth == ClientAuth.OPTIONAL;
    }

    public final synchronized void setVerify(int n, int n2) {
        if (!this.isDestroyed()) {
            SSL.setVerify((long)this.ssl, (int)n, (int)n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setClientAuth(ClientAuth clientAuth) {
        if (this.clientMode) {
            return;
        }
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this;
        synchronized (referenceCountedOpenSslEngine) {
            if (this.clientAuth == clientAuth) {
                return;
            }
            if (!this.isDestroyed()) {
                switch (clientAuth) {
                    case NONE: {
                        SSL.setVerify((long)this.ssl, (int)0, (int)10);
                        break;
                    }
                    case REQUIRE: {
                        SSL.setVerify((long)this.ssl, (int)2, (int)10);
                        break;
                    }
                    case OPTIONAL: {
                        SSL.setVerify((long)this.ssl, (int)1, (int)10);
                        break;
                    }
                    default: {
                        throw new Error(clientAuth.toString());
                    }
                }
            }
            this.clientAuth = clientAuth;
        }
    }

    @Override
    public final void setEnableSessionCreation(boolean bl) {
        if (bl) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public final boolean getEnableSessionCreation() {
        return false;
    }

    @Override
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    public final synchronized SSLParameters getSSLParameters() {
        SSLParameters sSLParameters = super.getSSLParameters();
        int n = PlatformDependent.javaVersion();
        if (n >= 7) {
            sSLParameters.setEndpointIdentificationAlgorithm(this.endPointIdentificationAlgorithm);
            Java7SslParametersUtils.setAlgorithmConstraints(sSLParameters, this.algorithmConstraints);
            if (n >= 8) {
                if (this.sniHostNames != null) {
                    Java8SslUtils.setSniHostNames(sSLParameters, this.sniHostNames);
                }
                if (!this.isDestroyed()) {
                    Java8SslUtils.setUseCipherSuitesOrder(sSLParameters, (SSL.getOptions((long)this.ssl) & SSL.SSL_OP_CIPHER_SERVER_PREFERENCE) != 0);
                }
                Java8SslUtils.setSNIMatchers(sSLParameters, this.matchers);
            }
        }
        return sSLParameters;
    }

    @Override
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    public final synchronized void setSSLParameters(SSLParameters sSLParameters) {
        int n = PlatformDependent.javaVersion();
        if (n >= 7) {
            Object object;
            if (sSLParameters.getAlgorithmConstraints() != null) {
                throw new IllegalArgumentException("AlgorithmConstraints are not supported.");
            }
            boolean bl = this.isDestroyed();
            if (n >= 8) {
                if (!bl) {
                    if (this.clientMode) {
                        object = Java8SslUtils.getSniHostNames(sSLParameters);
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            String string = (String)iterator.next();
                            SSL.setTlsExtHostName((long)this.ssl, (String)string);
                        }
                        this.sniHostNames = object;
                    }
                    if (Java8SslUtils.getUseCipherSuitesOrder(sSLParameters)) {
                        SSL.setOptions((long)this.ssl, (int)SSL.SSL_OP_CIPHER_SERVER_PREFERENCE);
                    } else {
                        SSL.clearOptions((long)this.ssl, (int)SSL.SSL_OP_CIPHER_SERVER_PREFERENCE);
                    }
                }
                this.matchers = sSLParameters.getSNIMatchers();
            }
            object = sSLParameters.getEndpointIdentificationAlgorithm();
            if (!bl && this.clientMode && ReferenceCountedOpenSslEngine.isEndPointVerificationEnabled((String)object)) {
                SSL.setVerify((long)this.ssl, (int)2, (int)-1);
            }
            this.endPointIdentificationAlgorithm = object;
            this.algorithmConstraints = sSLParameters.getAlgorithmConstraints();
        }
        super.setSSLParameters(sSLParameters);
    }

    private static boolean isEndPointVerificationEnabled(String string) {
        return string != null && !string.isEmpty();
    }

    private boolean isDestroyed() {
        return this.destroyed;
    }

    final boolean checkSniHostnameMatch(byte[] byArray) {
        return Java8SslUtils.checkSniHostnameMatch(this.matchers, byArray);
    }

    @Override
    public String getNegotiatedApplicationProtocol() {
        return this.applicationProtocol;
    }

    private static long bufferAddress(ByteBuffer byteBuffer) {
        assert (byteBuffer.isDirect());
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent.directBufferAddress(byteBuffer);
        }
        return Buffer.address((ByteBuffer)byteBuffer);
    }

    private void selectApplicationProtocol() {
        ApplicationProtocolConfig$SelectedListenerFailureBehavior applicationProtocolConfig$SelectedListenerFailureBehavior = this.apn.selectedListenerFailureBehavior();
        List<String> list = this.apn.protocols();
        switch (this.apn.protocol()) {
            case NONE: {
                break;
            }
            case ALPN: {
                String string = SSL.getAlpnSelected((long)this.ssl);
                if (string == null) break;
                this.applicationProtocol = this.selectApplicationProtocol(list, applicationProtocolConfig$SelectedListenerFailureBehavior, string);
                break;
            }
            case NPN: {
                String string = SSL.getNextProtoNegotiated((long)this.ssl);
                if (string == null) break;
                this.applicationProtocol = this.selectApplicationProtocol(list, applicationProtocolConfig$SelectedListenerFailureBehavior, string);
                break;
            }
            case NPN_AND_ALPN: {
                String string = SSL.getAlpnSelected((long)this.ssl);
                if (string == null) {
                    string = SSL.getNextProtoNegotiated((long)this.ssl);
                }
                if (string == null) break;
                this.applicationProtocol = this.selectApplicationProtocol(list, applicationProtocolConfig$SelectedListenerFailureBehavior, string);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    private String selectApplicationProtocol(List<String> list, ApplicationProtocolConfig$SelectedListenerFailureBehavior applicationProtocolConfig$SelectedListenerFailureBehavior, String string) {
        if (applicationProtocolConfig$SelectedListenerFailureBehavior == ApplicationProtocolConfig$SelectedListenerFailureBehavior.ACCEPT) {
            return string;
        }
        int n = list.size();
        assert (n > 0);
        if (list.contains(string)) {
            return string;
        }
        if (applicationProtocolConfig$SelectedListenerFailureBehavior == ApplicationProtocolConfig$SelectedListenerFailureBehavior.CHOOSE_MY_LAST_PROTOCOL) {
            return list.get(n - 1);
        }
        throw new SSLException("unknown protocol " + string);
    }

    final void setSessionId(OpenSslSessionId openSslSessionId) {
        this.session.setSessionId(openSslSessionId);
    }

    static /* synthetic */ ResourceLeakTracker access$000(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.leak;
    }

    static /* synthetic */ ReferenceCountedOpenSslContext access$100(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.parentContext;
    }

    static /* synthetic */ boolean access$200(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.clientMode;
    }

    static /* synthetic */ List access$300(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.sniHostNames;
    }

    static /* synthetic */ boolean access$400(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.isDestroyed();
    }

    static /* synthetic */ long access$500(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.ssl;
    }

    static /* synthetic */ boolean access$600(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.enableOcsp;
    }

    static /* synthetic */ void access$700(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, Runnable runnable) {
        referenceCountedOpenSslEngine.runAndResetNeedTask(runnable);
    }

    static /* synthetic */ OpenSslSession access$800(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.session;
    }

    static /* synthetic */ long access$900(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        return referenceCountedOpenSslEngine.lastAccessed;
    }

    static /* synthetic */ String access$1000(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, String string) {
        return referenceCountedOpenSslEngine.toJavaCipherSuite(string);
    }

    static /* synthetic */ boolean access$1100(Object[] objectArray) {
        return ReferenceCountedOpenSslEngine.isEmpty(objectArray);
    }

    static /* synthetic */ boolean access$1200(byte[] byArray) {
        return ReferenceCountedOpenSslEngine.isEmpty(byArray);
    }

    static /* synthetic */ void access$1300(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine) {
        referenceCountedOpenSslEngine.calculateMaxWrapOverhead();
    }

    static /* synthetic */ ReferenceCountedOpenSslEngine$HandshakeState access$1402(ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine, ReferenceCountedOpenSslEngine$HandshakeState referenceCountedOpenSslEngine$HandshakeState) {
        referenceCountedOpenSslEngine.handshakeState = referenceCountedOpenSslEngine$HandshakeState;
        return referenceCountedOpenSslEngine.handshakeState;
    }
}

