/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.websocketx;

import java.util.List;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelFutureListener;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelPipeline;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultFullHttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponseStatus;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpVersion;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.Utf8FrameValidator;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketProtocolHandler;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketServerHandshakeException;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketServerProtocolConfig;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandshakeHandler;
import pro.gravit.repackage.io.netty.util.AttributeKey;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public class WebSocketServerProtocolHandler
extends WebSocketProtocolHandler {
    private static final AttributeKey<WebSocketServerHandshaker> HANDSHAKER_ATTR_KEY = AttributeKey.valueOf(WebSocketServerHandshaker.class, "HANDSHAKER");
    private final WebSocketServerProtocolConfig serverConfig;

    public WebSocketServerProtocolHandler(WebSocketServerProtocolConfig webSocketServerProtocolConfig) {
        super(ObjectUtil.checkNotNull(webSocketServerProtocolConfig, "serverConfig").dropPongFrames(), webSocketServerProtocolConfig.sendCloseFrame(), webSocketServerProtocolConfig.forceCloseTimeoutMillis());
        this.serverConfig = webSocketServerProtocolConfig;
    }

    public WebSocketServerProtocolHandler(String string) {
        this(string, 10000L);
    }

    public WebSocketServerProtocolHandler(String string, long l) {
        this(string, false, l);
    }

    public WebSocketServerProtocolHandler(String string, boolean bl) {
        this(string, bl, 10000L);
    }

    public WebSocketServerProtocolHandler(String string, boolean bl, long l) {
        this(string, null, false, 65536, false, bl, l);
    }

    public WebSocketServerProtocolHandler(String string, String string2) {
        this(string, string2, 10000L);
    }

    public WebSocketServerProtocolHandler(String string, String string2, long l) {
        this(string, string2, false, l);
    }

    public WebSocketServerProtocolHandler(String string, String string2, boolean bl) {
        this(string, string2, bl, 10000L);
    }

    public WebSocketServerProtocolHandler(String string, String string2, boolean bl, long l) {
        this(string, string2, bl, 65536, l);
    }

    public WebSocketServerProtocolHandler(String string, String string2, boolean bl, int n) {
        this(string, string2, bl, n, 10000L);
    }

    public WebSocketServerProtocolHandler(String string, String string2, boolean bl, int n, long l) {
        this(string, string2, bl, n, false, l);
    }

    public WebSocketServerProtocolHandler(String string, String string2, boolean bl, int n, boolean bl2) {
        this(string, string2, bl, n, bl2, 10000L);
    }

    public WebSocketServerProtocolHandler(String string, String string2, boolean bl, int n, boolean bl2, long l) {
        this(string, string2, bl, n, bl2, false, l);
    }

    public WebSocketServerProtocolHandler(String string, String string2, boolean bl, int n, boolean bl2, boolean bl3) {
        this(string, string2, bl, n, bl2, bl3, 10000L);
    }

    public WebSocketServerProtocolHandler(String string, String string2, boolean bl, int n, boolean bl2, boolean bl3, long l) {
        this(string, string2, bl, n, bl2, bl3, true, l);
    }

    public WebSocketServerProtocolHandler(String string, String string2, boolean bl, int n, boolean bl2, boolean bl3, boolean bl4) {
        this(string, string2, bl, n, bl2, bl3, bl4, 10000L);
    }

    public WebSocketServerProtocolHandler(String string, String string2, boolean bl, int n, boolean bl2, boolean bl3, boolean bl4, long l) {
        this(string, string2, bl3, bl4, l, WebSocketDecoderConfig.newBuilder().maxFramePayloadLength(n).allowMaskMismatch(bl2).allowExtensions(bl).build());
    }

    public WebSocketServerProtocolHandler(String string, String string2, boolean bl, boolean bl2, long l, WebSocketDecoderConfig webSocketDecoderConfig) {
        this(WebSocketServerProtocolConfig.newBuilder().websocketPath(string).subprotocols(string2).checkStartsWith(bl).handshakeTimeoutMillis(l).dropPongFrames(bl2).decoderConfig(webSocketDecoderConfig).build());
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        ChannelPipeline channelPipeline = channelHandlerContext.pipeline();
        if (channelPipeline.get(WebSocketServerProtocolHandshakeHandler.class) == null) {
            channelPipeline.addBefore(channelHandlerContext.name(), WebSocketServerProtocolHandshakeHandler.class.getName(), new WebSocketServerProtocolHandshakeHandler(this.serverConfig));
        }
        if (this.serverConfig.decoderConfig().withUTF8Validator() && channelPipeline.get(Utf8FrameValidator.class) == null) {
            channelPipeline.addBefore(channelHandlerContext.name(), Utf8FrameValidator.class.getName(), new Utf8FrameValidator(this.serverConfig.decoderConfig().closeOnProtocolViolation()));
        }
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, WebSocketFrame webSocketFrame, List<Object> list) {
        if (this.serverConfig.handleCloseFrames() && webSocketFrame instanceof CloseWebSocketFrame) {
            WebSocketServerHandshaker webSocketServerHandshaker = WebSocketServerProtocolHandler.getHandshaker(channelHandlerContext.channel());
            if (webSocketServerHandshaker != null) {
                webSocketFrame.retain();
                ChannelPromise channelPromise = channelHandlerContext.newPromise();
                this.closeSent(channelPromise);
                webSocketServerHandshaker.close(channelHandlerContext, (CloseWebSocketFrame)webSocketFrame, channelPromise);
            } else {
                channelHandlerContext.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
            }
            return;
        }
        super.decode(channelHandlerContext, webSocketFrame, list);
    }

    @Override
    protected WebSocketServerHandshakeException buildHandshakeException(String string) {
        return new WebSocketServerHandshakeException(string);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        if (throwable instanceof WebSocketHandshakeException) {
            DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, Unpooled.wrappedBuffer(throwable.getMessage().getBytes()));
            channelHandlerContext.channel().writeAndFlush(defaultFullHttpResponse).addListener(ChannelFutureListener.CLOSE);
        } else {
            channelHandlerContext.fireExceptionCaught(throwable);
            channelHandlerContext.close();
        }
    }

    static WebSocketServerHandshaker getHandshaker(Channel channel) {
        return channel.attr(HANDSHAKER_ATTR_KEY).get();
    }

    static void setHandshaker(Channel channel, WebSocketServerHandshaker webSocketServerHandshaker) {
        channel.attr(HANDSHAKER_ATTR_KEY).set(webSocketServerHandshaker);
    }
}

