/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.websocketx;

import java.net.URI;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultFullHttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.FullHttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.FullHttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderNames;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderValues;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaders;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpMethod;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponseStatus;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpVersion;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocket08FrameEncoder;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketUtil;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import pro.gravit.repackage.io.netty.util.CharsetUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public class WebSocketClientHandshaker08
extends WebSocketClientHandshaker {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketClientHandshaker08.class);
    public static final String MAGIC_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private String expectedChallengeResponseString;
    private final boolean allowExtensions;
    private final boolean performMasking;
    private final boolean allowMaskMismatch;

    public WebSocketClientHandshaker08(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl, HttpHeaders httpHeaders, int n) {
        this(uRI, webSocketVersion, string, bl, httpHeaders, n, true, false, 10000L);
    }

    public WebSocketClientHandshaker08(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl, HttpHeaders httpHeaders, int n, boolean bl2, boolean bl3) {
        this(uRI, webSocketVersion, string, bl, httpHeaders, n, bl2, bl3, 10000L);
    }

    public WebSocketClientHandshaker08(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl, HttpHeaders httpHeaders, int n, boolean bl2, boolean bl3, long l) {
        this(uRI, webSocketVersion, string, bl, httpHeaders, n, bl2, bl3, l, false, true);
    }

    WebSocketClientHandshaker08(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl, HttpHeaders httpHeaders, int n, boolean bl2, boolean bl3, long l, boolean bl4) {
        this(uRI, webSocketVersion, string, bl, httpHeaders, n, bl2, bl3, l, bl4, true);
    }

    WebSocketClientHandshaker08(URI uRI, WebSocketVersion webSocketVersion, String string, boolean bl, HttpHeaders httpHeaders, int n, boolean bl2, boolean bl3, long l, boolean bl4, boolean bl5) {
        super(uRI, webSocketVersion, string, httpHeaders, n, l, bl4, bl5);
        this.allowExtensions = bl;
        this.performMasking = bl2;
        this.allowMaskMismatch = bl3;
    }

    @Override
    protected FullHttpRequest newHandshakeRequest() {
        String string;
        URI uRI = this.uri();
        byte[] byArray = WebSocketUtil.randomBytes(16);
        String string2 = WebSocketUtil.base64(byArray);
        String string3 = string2 + MAGIC_GUID;
        byte[] byArray2 = WebSocketUtil.sha1(string3.getBytes(CharsetUtil.US_ASCII));
        this.expectedChallengeResponseString = WebSocketUtil.base64(byArray2);
        if (logger.isDebugEnabled()) {
            logger.debug("WebSocket version 08 client handshake key: {}, expected response: {}", (Object)string2, (Object)this.expectedChallengeResponseString);
        }
        DefaultFullHttpRequest defaultFullHttpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, this.upgradeUrl(uRI), Unpooled.EMPTY_BUFFER);
        HttpHeaders httpHeaders = defaultFullHttpRequest.headers();
        if (this.customHeaders != null) {
            httpHeaders.add(this.customHeaders);
            if (!httpHeaders.contains(HttpHeaderNames.HOST)) {
                httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)WebSocketClientHandshaker08.websocketHostValue(uRI));
            }
        } else {
            httpHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)WebSocketClientHandshaker08.websocketHostValue(uRI));
        }
        httpHeaders.set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY, (Object)string2);
        if (this.generateOriginHeader && !httpHeaders.contains(HttpHeaderNames.SEC_WEBSOCKET_ORIGIN)) {
            httpHeaders.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, (Object)WebSocketClientHandshaker08.websocketOriginValue(uRI));
        }
        if ((string = this.expectedSubprotocol()) != null && !string.isEmpty()) {
            httpHeaders.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)string);
        }
        httpHeaders.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)this.version().toAsciiString());
        return defaultFullHttpRequest;
    }

    @Override
    protected void verify(FullHttpResponse fullHttpResponse) {
        HttpResponseStatus httpResponseStatus = fullHttpResponse.status();
        if (!HttpResponseStatus.SWITCHING_PROTOCOLS.equals(httpResponseStatus)) {
            throw new WebSocketClientHandshakeException("Invalid handshake response getStatus: " + httpResponseStatus, fullHttpResponse);
        }
        HttpHeaders httpHeaders = fullHttpResponse.headers();
        String string = httpHeaders.get(HttpHeaderNames.UPGRADE);
        if (!HttpHeaderValues.WEBSOCKET.contentEqualsIgnoreCase(string)) {
            throw new WebSocketClientHandshakeException("Invalid handshake response upgrade: " + string, fullHttpResponse);
        }
        if (!httpHeaders.containsValue(HttpHeaderNames.CONNECTION, HttpHeaderValues.UPGRADE, true)) {
            throw new WebSocketClientHandshakeException("Invalid handshake response connection: " + httpHeaders.get(HttpHeaderNames.CONNECTION), fullHttpResponse);
        }
        String string2 = httpHeaders.get(HttpHeaderNames.SEC_WEBSOCKET_ACCEPT);
        if (string2 == null || !string2.equals(this.expectedChallengeResponseString)) {
            throw new WebSocketClientHandshakeException(String.format("Invalid challenge. Actual: %s. Expected: %s", string2, this.expectedChallengeResponseString), fullHttpResponse);
        }
    }

    @Override
    protected WebSocketFrameDecoder newWebsocketDecoder() {
        return new WebSocket08FrameDecoder(false, this.allowExtensions, this.maxFramePayloadLength(), this.allowMaskMismatch);
    }

    @Override
    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return new WebSocket08FrameEncoder(this.performMasking);
    }

    @Override
    public WebSocketClientHandshaker08 setForceCloseTimeoutMillis(long l) {
        super.setForceCloseTimeoutMillis(l);
        return this;
    }
}

