/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.websocketx;

import java.nio.channels.ClosedChannelException;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelInboundHandlerAdapter;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultFullHttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.EmptyHttpHeaders;
import pro.gravit.repackage.io.netty.handler.codec.http.FullHttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpObject;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpResponse;
import pro.gravit.repackage.io.netty.handler.codec.http.LastHttpContent;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import pro.gravit.repackage.io.netty.util.ReferenceCountUtil;

class WebSocketClientHandshaker$4
extends ChannelInboundHandlerAdapter {
    private FullHttpResponse fullHttpResponse;
    static final /* synthetic */ boolean $assertionsDisabled;
    final /* synthetic */ ChannelPromise val$promise;
    final /* synthetic */ Channel val$channel;
    final /* synthetic */ WebSocketClientHandshaker this$0;

    WebSocketClientHandshaker$4(WebSocketClientHandshaker webSocketClientHandshaker, ChannelPromise channelPromise, Channel channel) {
        this.this$0 = webSocketClientHandshaker;
        this.val$promise = channelPromise;
        this.val$channel = channel;
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof HttpObject) {
            try {
                this.handleHandshakeResponse(channelHandlerContext, (HttpObject)object);
            }
            finally {
                ReferenceCountUtil.release(object);
            }
        } else {
            super.channelRead(channelHandlerContext, object);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        channelHandlerContext.pipeline().remove(this);
        this.val$promise.setFailure(throwable);
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        try {
            if (!this.val$promise.isDone()) {
                this.val$promise.tryFailure(new ClosedChannelException());
            }
            channelHandlerContext.fireChannelInactive();
        }
        finally {
            this.releaseFullHttpResponse();
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.releaseFullHttpResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHandshakeResponse(ChannelHandlerContext channelHandlerContext, HttpObject httpObject) {
        if (httpObject instanceof FullHttpResponse) {
            channelHandlerContext.pipeline().remove(this);
            this.tryFinishHandshake((FullHttpResponse)httpObject);
            return;
        }
        if (httpObject instanceof LastHttpContent) {
            if (!$assertionsDisabled && this.fullHttpResponse == null) {
                throw new AssertionError();
            }
            FullHttpResponse fullHttpResponse = this.fullHttpResponse;
            this.fullHttpResponse = null;
            try {
                channelHandlerContext.pipeline().remove(this);
                this.tryFinishHandshake(fullHttpResponse);
            }
            finally {
                fullHttpResponse.release();
            }
            return;
        }
        if (httpObject instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)httpObject;
            this.fullHttpResponse = new DefaultFullHttpResponse(httpResponse.protocolVersion(), httpResponse.status(), Unpooled.EMPTY_BUFFER, httpResponse.headers(), EmptyHttpHeaders.INSTANCE);
            if (httpResponse.decoderResult().isFailure()) {
                this.fullHttpResponse.setDecoderResult(httpResponse.decoderResult());
            }
        }
    }

    private void tryFinishHandshake(FullHttpResponse fullHttpResponse) {
        try {
            this.this$0.finishHandshake(this.val$channel, fullHttpResponse);
            this.val$promise.setSuccess();
        }
        catch (Throwable throwable) {
            this.val$promise.setFailure(throwable);
        }
    }

    private void releaseFullHttpResponse() {
        if (this.fullHttpResponse != null) {
            this.fullHttpResponse.release();
            this.fullHttpResponse = null;
        }
    }

    static {
        $assertionsDisabled = !WebSocketClientHandshaker.class.desiredAssertionStatus();
    }
}

