/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel.nio;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.buffer.ByteBufUtil;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.channel.AbstractChannel;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelException;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.channel.EventLoop;
import pro.gravit.repackage.io.netty.channel.nio.AbstractNioChannel$1;
import pro.gravit.repackage.io.netty.channel.nio.AbstractNioChannel$2;
import pro.gravit.repackage.io.netty.channel.nio.AbstractNioChannel$AbstractNioUnsafe;
import pro.gravit.repackage.io.netty.channel.nio.AbstractNioChannel$NioUnsafe;
import pro.gravit.repackage.io.netty.channel.nio.NioEventLoop;
import pro.gravit.repackage.io.netty.util.ReferenceCountUtil;
import pro.gravit.repackage.io.netty.util.ReferenceCounted;
import pro.gravit.repackage.io.netty.util.concurrent.Future;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public abstract class AbstractNioChannel
extends AbstractChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractNioChannel.class);
    private final SelectableChannel ch;
    protected final int readInterestOp;
    volatile SelectionKey selectionKey;
    boolean readPending;
    private final Runnable clearReadPendingRunnable = new AbstractNioChannel$1(this);
    private ChannelPromise connectPromise;
    private Future<?> connectTimeoutFuture;
    private SocketAddress requestedRemoteAddress;

    protected AbstractNioChannel(Channel channel, SelectableChannel selectableChannel, int n) {
        super(channel);
        this.ch = selectableChannel;
        this.readInterestOp = n;
        try {
            selectableChannel.configureBlocking(false);
        }
        catch (IOException iOException) {
            try {
                selectableChannel.close();
            }
            catch (IOException iOException2) {
                logger.warn("Failed to close a partially initialized socket.", iOException2);
            }
            throw new ChannelException("Failed to enter non-blocking mode.", iOException);
        }
    }

    @Override
    public boolean isOpen() {
        return this.ch.isOpen();
    }

    @Override
    public AbstractNioChannel$NioUnsafe unsafe() {
        return (AbstractNioChannel$NioUnsafe)super.unsafe();
    }

    protected SelectableChannel javaChannel() {
        return this.ch;
    }

    @Override
    public NioEventLoop eventLoop() {
        return (NioEventLoop)super.eventLoop();
    }

    protected SelectionKey selectionKey() {
        assert (this.selectionKey != null);
        return this.selectionKey;
    }

    @Deprecated
    protected boolean isReadPending() {
        return this.readPending;
    }

    @Deprecated
    protected void setReadPending(boolean bl) {
        if (this.isRegistered()) {
            NioEventLoop nioEventLoop = this.eventLoop();
            if (nioEventLoop.inEventLoop()) {
                this.setReadPending0(bl);
            } else {
                nioEventLoop.execute(new AbstractNioChannel$2(this, bl));
            }
        } else {
            this.readPending = bl;
        }
    }

    protected final void clearReadPending() {
        if (this.isRegistered()) {
            NioEventLoop nioEventLoop = this.eventLoop();
            if (nioEventLoop.inEventLoop()) {
                this.clearReadPending0();
            } else {
                nioEventLoop.execute(this.clearReadPendingRunnable);
            }
        } else {
            this.readPending = false;
        }
    }

    private void setReadPending0(boolean bl) {
        this.readPending = bl;
        if (!bl) {
            ((AbstractNioChannel$AbstractNioUnsafe)this.unsafe()).removeReadOp();
        }
    }

    private void clearReadPending0() {
        this.readPending = false;
        ((AbstractNioChannel$AbstractNioUnsafe)this.unsafe()).removeReadOp();
    }

    @Override
    protected boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof NioEventLoop;
    }

    @Override
    protected void doRegister() {
        boolean bl = false;
        while (true) {
            try {
                this.selectionKey = this.javaChannel().register(this.eventLoop().unwrappedSelector(), 0, this);
                return;
            }
            catch (CancelledKeyException cancelledKeyException) {
                if (!bl) {
                    this.eventLoop().selectNow();
                    bl = true;
                    continue;
                }
                throw cancelledKeyException;
            }
            break;
        }
    }

    @Override
    protected void doDeregister() {
        this.eventLoop().cancel(this.selectionKey());
    }

    @Override
    protected void doBeginRead() {
        SelectionKey selectionKey = this.selectionKey;
        if (!selectionKey.isValid()) {
            return;
        }
        this.readPending = true;
        int n = selectionKey.interestOps();
        if ((n & this.readInterestOp) == 0) {
            selectionKey.interestOps(n | this.readInterestOp);
        }
    }

    protected abstract boolean doConnect(SocketAddress var1, SocketAddress var2);

    protected abstract void doFinishConnect();

    protected final ByteBuf newDirectBuffer(ByteBuf byteBuf) {
        int n = byteBuf.readableBytes();
        if (n == 0) {
            ReferenceCountUtil.safeRelease(byteBuf);
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBufAllocator byteBufAllocator = this.alloc();
        if (byteBufAllocator.isDirectBufferPooled()) {
            ByteBuf byteBuf2 = byteBufAllocator.directBuffer(n);
            byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n);
            ReferenceCountUtil.safeRelease(byteBuf);
            return byteBuf2;
        }
        ByteBuf byteBuf3 = ByteBufUtil.threadLocalDirectBuffer();
        if (byteBuf3 != null) {
            byteBuf3.writeBytes(byteBuf, byteBuf.readerIndex(), n);
            ReferenceCountUtil.safeRelease(byteBuf);
            return byteBuf3;
        }
        return byteBuf;
    }

    protected final ByteBuf newDirectBuffer(ReferenceCounted referenceCounted, ByteBuf byteBuf) {
        int n = byteBuf.readableBytes();
        if (n == 0) {
            ReferenceCountUtil.safeRelease(referenceCounted);
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBufAllocator byteBufAllocator = this.alloc();
        if (byteBufAllocator.isDirectBufferPooled()) {
            ByteBuf byteBuf2 = byteBufAllocator.directBuffer(n);
            byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n);
            ReferenceCountUtil.safeRelease(referenceCounted);
            return byteBuf2;
        }
        ByteBuf byteBuf3 = ByteBufUtil.threadLocalDirectBuffer();
        if (byteBuf3 != null) {
            byteBuf3.writeBytes(byteBuf, byteBuf.readerIndex(), n);
            ReferenceCountUtil.safeRelease(referenceCounted);
            return byteBuf3;
        }
        if (referenceCounted != byteBuf) {
            byteBuf.retain();
            ReferenceCountUtil.safeRelease(referenceCounted);
        }
        return byteBuf;
    }

    @Override
    protected void doClose() {
        Future<?> future;
        ChannelPromise channelPromise = this.connectPromise;
        if (channelPromise != null) {
            channelPromise.tryFailure(new ClosedChannelException());
            this.connectPromise = null;
        }
        if ((future = this.connectTimeoutFuture) != null) {
            future.cancel(false);
            this.connectTimeoutFuture = null;
        }
    }

    static /* synthetic */ void access$000(AbstractNioChannel abstractNioChannel) {
        abstractNioChannel.clearReadPending0();
    }

    static /* synthetic */ void access$100(AbstractNioChannel abstractNioChannel, boolean bl) {
        abstractNioChannel.setReadPending0(bl);
    }

    static /* synthetic */ ChannelPromise access$200(AbstractNioChannel abstractNioChannel) {
        return abstractNioChannel.connectPromise;
    }

    static /* synthetic */ ChannelPromise access$202(AbstractNioChannel abstractNioChannel, ChannelPromise channelPromise) {
        abstractNioChannel.connectPromise = channelPromise;
        return abstractNioChannel.connectPromise;
    }

    static /* synthetic */ SocketAddress access$302(AbstractNioChannel abstractNioChannel, SocketAddress socketAddress) {
        abstractNioChannel.requestedRemoteAddress = socketAddress;
        return abstractNioChannel.requestedRemoteAddress;
    }

    static /* synthetic */ Future access$402(AbstractNioChannel abstractNioChannel, Future future) {
        abstractNioChannel.connectTimeoutFuture = future;
        return abstractNioChannel.connectTimeoutFuture;
    }

    static /* synthetic */ Future access$400(AbstractNioChannel abstractNioChannel) {
        return abstractNioChannel.connectTimeoutFuture;
    }

    static /* synthetic */ SocketAddress access$300(AbstractNioChannel abstractNioChannel) {
        return abstractNioChannel.requestedRemoteAddress;
    }
}

