/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.buffer;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import pro.gravit.repackage.io.netty.buffer.AbstractByteBufAllocator;
import pro.gravit.repackage.io.netty.buffer.AbstractReferenceCountedByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocatorMetricProvider;
import pro.gravit.repackage.io.netty.buffer.PoolArena;
import pro.gravit.repackage.io.netty.buffer.PoolArena$DirectArena;
import pro.gravit.repackage.io.netty.buffer.PoolArena$HeapArena;
import pro.gravit.repackage.io.netty.buffer.PoolArenaMetric;
import pro.gravit.repackage.io.netty.buffer.PoolArenasCache;
import pro.gravit.repackage.io.netty.buffer.PooledByteBufAllocator$1;
import pro.gravit.repackage.io.netty.buffer.PooledByteBufAllocator$PoolThreadLocalCache;
import pro.gravit.repackage.io.netty.buffer.PooledByteBufAllocatorMetric;
import pro.gravit.repackage.io.netty.buffer.UnpooledDirectByteBuf;
import pro.gravit.repackage.io.netty.buffer.UnpooledHeapByteBuf;
import pro.gravit.repackage.io.netty.buffer.UnpooledUnsafeHeapByteBuf;
import pro.gravit.repackage.io.netty.buffer.UnsafeByteBufUtil;
import pro.gravit.repackage.io.netty.util.NettyRuntime;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.StringUtil;
import pro.gravit.repackage.io.netty.util.internal.SystemPropertyUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public class PooledByteBufAllocator
extends AbstractByteBufAllocator
implements ByteBufAllocatorMetricProvider {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PooledByteBufAllocator.class);
    private static final int DEFAULT_NUM_HEAP_ARENA;
    private static final int DEFAULT_NUM_DIRECT_ARENA;
    private static final int DEFAULT_PAGE_SIZE;
    private static final int DEFAULT_MAX_ORDER;
    private static final int DEFAULT_SMALL_CACHE_SIZE;
    private static final int DEFAULT_NORMAL_CACHE_SIZE;
    static final int DEFAULT_MAX_CACHED_BUFFER_CAPACITY;
    private static final int DEFAULT_CACHE_TRIM_INTERVAL;
    private static final long DEFAULT_CACHE_TRIM_INTERVAL_MILLIS;
    private static final boolean DEFAULT_USE_CACHE_FOR_ALL_THREADS;
    private static final int DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT;
    static final int DEFAULT_MAX_CACHED_BYTEBUFFERS_PER_CHUNK;
    private static final int MIN_PAGE_SIZE = 4096;
    private static final int MAX_CHUNK_SIZE = 0x40000000;
    private static final int CACHE_NOT_USED = 0;
    private final Runnable trimTask = new PooledByteBufAllocator$1(this);
    public static final PooledByteBufAllocator DEFAULT;
    private final PoolArena<byte[]>[] heapArenas;
    private final PoolArena<ByteBuffer>[] directArenas;
    private final int smallCacheSize;
    private final int normalCacheSize;
    private final List<PoolArenaMetric> heapArenaMetrics;
    private final List<PoolArenaMetric> directArenaMetrics;
    private final PooledByteBufAllocator$PoolThreadLocalCache threadCache;
    private final int chunkSize;
    private final PooledByteBufAllocatorMetric metric;

    public PooledByteBufAllocator() {
        this(false);
    }

    public PooledByteBufAllocator(boolean bl) {
        this(bl, DEFAULT_NUM_HEAP_ARENA, DEFAULT_NUM_DIRECT_ARENA, DEFAULT_PAGE_SIZE, DEFAULT_MAX_ORDER);
    }

    public PooledByteBufAllocator(int n, int n2, int n3, int n4) {
        this(false, n, n2, n3, n4);
    }

    @Deprecated
    public PooledByteBufAllocator(boolean bl, int n, int n2, int n3, int n4) {
        this(bl, n, n2, n3, n4, 0, DEFAULT_SMALL_CACHE_SIZE, DEFAULT_NORMAL_CACHE_SIZE);
    }

    @Deprecated
    public PooledByteBufAllocator(boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this(bl, n, n2, n3, n4, n6, n7, DEFAULT_USE_CACHE_FOR_ALL_THREADS, DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT);
    }

    @Deprecated
    public PooledByteBufAllocator(boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        this(bl, n, n2, n3, n4, n6, n7, bl2);
    }

    public PooledByteBufAllocator(boolean bl, int n, int n2, int n3, int n4, int n5, int n6, boolean bl2) {
        this(bl, n, n2, n3, n4, n5, n6, bl2, DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT);
    }

    @Deprecated
    public PooledByteBufAllocator(boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2, int n8) {
        this(bl, n, n2, n3, n4, n6, n7, bl2, n8);
    }

    public PooledByteBufAllocator(boolean bl, int n, int n2, int n3, int n4, int n5, int n6, boolean bl2, int n7) {
        super(bl);
        PoolArena poolArena;
        int n8;
        ArrayList<PoolArena$HeapArena> arrayList;
        this.threadCache = new PooledByteBufAllocator$PoolThreadLocalCache(this, bl2);
        this.smallCacheSize = n5;
        this.normalCacheSize = n6;
        if (n7 != 0) {
            if (!PlatformDependent.hasAlignDirectByteBuffer()) {
                throw new UnsupportedOperationException("Buffer alignment is not supported. Either Unsafe or ByteBuffer.alignSlice() must be available.");
            }
            n3 = (int)PlatformDependent.align(n3, n7);
        }
        this.chunkSize = PooledByteBufAllocator.validateAndCalculateChunkSize(n3, n4);
        ObjectUtil.checkPositiveOrZero(n, "nHeapArena");
        ObjectUtil.checkPositiveOrZero(n2, "nDirectArena");
        ObjectUtil.checkPositiveOrZero(n7, "directMemoryCacheAlignment");
        if (n7 > 0 && !PooledByteBufAllocator.isDirectMemoryCacheAlignmentSupported()) {
            throw new IllegalArgumentException("directMemoryCacheAlignment is not supported");
        }
        if ((n7 & -n7) != n7) {
            throw new IllegalArgumentException("directMemoryCacheAlignment: " + n7 + " (expected: power of two)");
        }
        int n9 = PooledByteBufAllocator.validateAndCalculatePageShifts(n3, n7);
        if (n > 0) {
            this.heapArenas = PooledByteBufAllocator.newArenaArray(n);
            arrayList = new ArrayList<PoolArena$HeapArena>(this.heapArenas.length);
            for (n8 = 0; n8 < this.heapArenas.length; ++n8) {
                this.heapArenas[n8] = poolArena = new PoolArena$HeapArena(this, n3, n9, this.chunkSize);
                arrayList.add((PoolArena$HeapArena)poolArena);
            }
            this.heapArenaMetrics = Collections.unmodifiableList(arrayList);
        } else {
            this.heapArenas = null;
            this.heapArenaMetrics = Collections.emptyList();
        }
        if (n2 > 0) {
            this.directArenas = PooledByteBufAllocator.newArenaArray(n2);
            arrayList = new ArrayList(this.directArenas.length);
            for (n8 = 0; n8 < this.directArenas.length; ++n8) {
                this.directArenas[n8] = poolArena = new PoolArena$DirectArena(this, n3, n9, this.chunkSize, n7);
                arrayList.add((PoolArena$HeapArena)poolArena);
            }
            this.directArenaMetrics = Collections.unmodifiableList(arrayList);
        } else {
            this.directArenas = null;
            this.directArenaMetrics = Collections.emptyList();
        }
        this.metric = new PooledByteBufAllocatorMetric(this);
    }

    private static <T> PoolArena<T>[] newArenaArray(int n) {
        return new PoolArena[n];
    }

    private static int validateAndCalculatePageShifts(int n, int n2) {
        if (n < 4096) {
            throw new IllegalArgumentException("pageSize: " + n + " (expected: " + 4096 + ')');
        }
        if ((n & n - 1) != 0) {
            throw new IllegalArgumentException("pageSize: " + n + " (expected: power of 2)");
        }
        if (n < n2) {
            throw new IllegalArgumentException("Alignment cannot be greater than page size. Alignment: " + n2 + ", page size: " + n + '.');
        }
        return 31 - Integer.numberOfLeadingZeros(n);
    }

    private static int validateAndCalculateChunkSize(int n, int n2) {
        if (n2 > 14) {
            throw new IllegalArgumentException("maxOrder: " + n2 + " (expected: 0-14)");
        }
        int n3 = n;
        for (int i = n2; i > 0; --i) {
            if (n3 > 0x20000000) {
                throw new IllegalArgumentException(String.format("pageSize (%d) << maxOrder (%d) must not exceed %d", n, n2, 0x40000000));
            }
            n3 <<= 1;
        }
        return n3;
    }

    private PoolArenasCache getPoolThreadCache() {
        return (PoolArenasCache)this.threadCache.get();
    }

    @Override
    protected ByteBuf newHeapBuffer(int n, int n2) {
        PoolArenasCache poolArenasCache = this.getPoolThreadCache();
        PoolArena<byte[]> poolArena = poolArenasCache.heapArena;
        AbstractReferenceCountedByteBuf abstractReferenceCountedByteBuf = poolArena != null ? poolArena.allocate(poolArenasCache, n, n2) : (PlatformDependent.hasUnsafe() ? new UnpooledUnsafeHeapByteBuf((ByteBufAllocator)this, n, n2) : new UnpooledHeapByteBuf((ByteBufAllocator)this, n, n2));
        return PooledByteBufAllocator.toLeakAwareBuffer(abstractReferenceCountedByteBuf);
    }

    @Override
    protected ByteBuf newDirectBuffer(int n, int n2) {
        PoolArenasCache poolArenasCache = this.getPoolThreadCache();
        PoolArena<ByteBuffer> poolArena = poolArenasCache.directArena;
        AbstractReferenceCountedByteBuf abstractReferenceCountedByteBuf = poolArena != null ? poolArena.allocate(poolArenasCache, n, n2) : (PlatformDependent.hasUnsafe() ? UnsafeByteBufUtil.newUnsafeDirectByteBuf(this, n, n2) : new UnpooledDirectByteBuf((ByteBufAllocator)this, n, n2));
        return PooledByteBufAllocator.toLeakAwareBuffer(abstractReferenceCountedByteBuf);
    }

    public static int defaultNumHeapArena() {
        return DEFAULT_NUM_HEAP_ARENA;
    }

    public static int defaultNumDirectArena() {
        return DEFAULT_NUM_DIRECT_ARENA;
    }

    public static int defaultPageSize() {
        return DEFAULT_PAGE_SIZE;
    }

    public static int defaultMaxOrder() {
        return DEFAULT_MAX_ORDER;
    }

    public static boolean defaultUseCacheForAllThreads() {
        return DEFAULT_USE_CACHE_FOR_ALL_THREADS;
    }

    public static boolean defaultPreferDirect() {
        return PlatformDependent.directBufferPreferred();
    }

    @Deprecated
    public static int defaultTinyCacheSize() {
        return 0;
    }

    public static int defaultSmallCacheSize() {
        return DEFAULT_SMALL_CACHE_SIZE;
    }

    public static int defaultNormalCacheSize() {
        return DEFAULT_NORMAL_CACHE_SIZE;
    }

    public static boolean isDirectMemoryCacheAlignmentSupported() {
        return PlatformDependent.hasUnsafe();
    }

    @Override
    public boolean isDirectBufferPooled() {
        return this.directArenas != null;
    }

    @Deprecated
    public boolean hasThreadLocalCache() {
        return this.threadCache.isSet();
    }

    @Deprecated
    public void freeThreadLocalCache() {
        this.threadCache.remove();
    }

    @Override
    public PooledByteBufAllocatorMetric metric() {
        return this.metric;
    }

    @Deprecated
    public int numHeapArenas() {
        return this.heapArenaMetrics.size();
    }

    @Deprecated
    public int numDirectArenas() {
        return this.directArenaMetrics.size();
    }

    @Deprecated
    public List<PoolArenaMetric> heapArenas() {
        return this.heapArenaMetrics;
    }

    @Deprecated
    public List<PoolArenaMetric> directArenas() {
        return this.directArenaMetrics;
    }

    @Deprecated
    public int numThreadLocalCaches() {
        PoolArena<Object>[] poolArenaArray;
        PoolArena<Object>[] poolArenaArray2 = poolArenaArray = this.heapArenas != null ? this.heapArenas : this.directArenas;
        if (poolArenaArray == null) {
            return 0;
        }
        int n = 0;
        for (PoolArena<Object> poolArena : poolArenaArray) {
            n += poolArena.numThreadCaches.get();
        }
        return n;
    }

    @Deprecated
    public int tinyCacheSize() {
        return 0;
    }

    @Deprecated
    public int smallCacheSize() {
        return this.smallCacheSize;
    }

    @Deprecated
    public int normalCacheSize() {
        return this.normalCacheSize;
    }

    @Deprecated
    public final int chunkSize() {
        return this.chunkSize;
    }

    final long usedHeapMemory() {
        return PooledByteBufAllocator.usedMemory(this.heapArenas);
    }

    final long usedDirectMemory() {
        return PooledByteBufAllocator.usedMemory(this.directArenas);
    }

    private static long usedMemory(PoolArena<?>[] poolArenaArray) {
        if (poolArenaArray == null) {
            return -1L;
        }
        long l = 0L;
        for (PoolArena<?> poolArena : poolArenaArray) {
            if ((l += poolArena.numActiveBytes()) >= 0L) continue;
            return Long.MAX_VALUE;
        }
        return l;
    }

    public final long pinnedHeapMemory() {
        return PooledByteBufAllocator.pinnedMemory(this.heapArenas);
    }

    public final long pinnedDirectMemory() {
        return PooledByteBufAllocator.pinnedMemory(this.directArenas);
    }

    private static long pinnedMemory(PoolArena<?>[] poolArenaArray) {
        if (poolArenaArray == null) {
            return -1L;
        }
        long l = 0L;
        for (PoolArena<?> poolArena : poolArenaArray) {
            if ((l += poolArena.numPinnedBytes()) >= 0L) continue;
            return Long.MAX_VALUE;
        }
        return l;
    }

    final PoolArenasCache threadCache() {
        PoolArenasCache poolArenasCache = this.getPoolThreadCache();
        assert (poolArenasCache != null);
        return poolArenasCache;
    }

    public boolean trimCurrentThreadCache() {
        PoolArenasCache poolArenasCache = (PoolArenasCache)this.threadCache.getIfExists();
        if (poolArenasCache != null) {
            poolArenasCache.trim();
            return true;
        }
        return false;
    }

    public String dumpStats() {
        int n = this.heapArenas == null ? 0 : this.heapArenas.length;
        StringBuilder stringBuilder = new StringBuilder(512).append(n).append(" heap arena(s):").append(StringUtil.NEWLINE);
        if (n > 0) {
            for (PoolArena<byte[]> poolArena : this.heapArenas) {
                stringBuilder.append(poolArena);
            }
        }
        int n2 = this.directArenas == null ? 0 : this.directArenas.length;
        stringBuilder.append(n2).append(" direct arena(s):").append(StringUtil.NEWLINE);
        if (n2 > 0) {
            for (PoolArena<ByteBuffer> poolArena : this.directArenas) {
                stringBuilder.append(poolArena);
            }
        }
        return stringBuilder.toString();
    }

    static /* synthetic */ PoolArena[] access$000(PooledByteBufAllocator pooledByteBufAllocator) {
        return pooledByteBufAllocator.heapArenas;
    }

    static /* synthetic */ PoolArena[] access$100(PooledByteBufAllocator pooledByteBufAllocator) {
        return pooledByteBufAllocator.directArenas;
    }

    static /* synthetic */ int access$200(PooledByteBufAllocator pooledByteBufAllocator) {
        return pooledByteBufAllocator.smallCacheSize;
    }

    static /* synthetic */ int access$300(PooledByteBufAllocator pooledByteBufAllocator) {
        return pooledByteBufAllocator.normalCacheSize;
    }

    static /* synthetic */ int access$400() {
        return DEFAULT_CACHE_TRIM_INTERVAL;
    }

    static /* synthetic */ long access$500() {
        return DEFAULT_CACHE_TRIM_INTERVAL_MILLIS;
    }

    static /* synthetic */ Runnable access$600(PooledByteBufAllocator pooledByteBufAllocator) {
        return pooledByteBufAllocator.trimTask;
    }

    static {
        int n = SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.allocator.directMemoryCacheAlignment", 0);
        int n2 = SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.allocator.pageSize", 8192);
        Throwable throwable = null;
        try {
            PooledByteBufAllocator.validateAndCalculatePageShifts(n2, n);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            n2 = 8192;
            n = 0;
        }
        DEFAULT_PAGE_SIZE = n2;
        DEFAULT_DIRECT_MEMORY_CACHE_ALIGNMENT = n;
        int n3 = SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.allocator.maxOrder", 9);
        Throwable throwable3 = null;
        try {
            PooledByteBufAllocator.validateAndCalculateChunkSize(DEFAULT_PAGE_SIZE, n3);
        }
        catch (Throwable throwable4) {
            throwable3 = throwable4;
            n3 = 9;
        }
        DEFAULT_MAX_ORDER = n3;
        Runtime runtime = Runtime.getRuntime();
        int n4 = NettyRuntime.availableProcessors() * 2;
        int n5 = DEFAULT_PAGE_SIZE << DEFAULT_MAX_ORDER;
        DEFAULT_NUM_HEAP_ARENA = Math.max(0, SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.allocator.numHeapArenas", (int)Math.min((long)n4, runtime.maxMemory() / (long)n5 / 2L / 3L)));
        DEFAULT_NUM_DIRECT_ARENA = Math.max(0, SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.allocator.numDirectArenas", (int)Math.min((long)n4, PlatformDependent.maxDirectMemory() / (long)n5 / 2L / 3L)));
        DEFAULT_SMALL_CACHE_SIZE = SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.allocator.smallCacheSize", 256);
        DEFAULT_NORMAL_CACHE_SIZE = SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.allocator.normalCacheSize", 64);
        DEFAULT_MAX_CACHED_BUFFER_CAPACITY = SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.allocator.maxCachedBufferCapacity", 32768);
        DEFAULT_CACHE_TRIM_INTERVAL = SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.allocator.cacheTrimInterval", 8192);
        if (SystemPropertyUtil.contains("pro.gravit.repackage.io.netty.allocation.cacheTrimIntervalMillis")) {
            logger.warn("-Dio.netty.allocation.cacheTrimIntervalMillis is deprecated, use -Dio.netty.allocator.cacheTrimIntervalMillis");
            DEFAULT_CACHE_TRIM_INTERVAL_MILLIS = SystemPropertyUtil.contains("pro.gravit.repackage.io.netty.allocator.cacheTrimIntervalMillis") ? SystemPropertyUtil.getLong("pro.gravit.repackage.io.netty.allocator.cacheTrimIntervalMillis", 0L) : SystemPropertyUtil.getLong("pro.gravit.repackage.io.netty.allocation.cacheTrimIntervalMillis", 0L);
        } else {
            DEFAULT_CACHE_TRIM_INTERVAL_MILLIS = SystemPropertyUtil.getLong("pro.gravit.repackage.io.netty.allocator.cacheTrimIntervalMillis", 0L);
        }
        DEFAULT_USE_CACHE_FOR_ALL_THREADS = SystemPropertyUtil.getBoolean("pro.gravit.repackage.io.netty.allocator.useCacheForAllThreads", false);
        DEFAULT_MAX_CACHED_BYTEBUFFERS_PER_CHUNK = SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.allocator.maxCachedByteBuffersPerChunk", 1023);
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.allocator.numHeapArenas: {}", (Object)DEFAULT_NUM_HEAP_ARENA);
            logger.debug("-Dio.netty.allocator.numDirectArenas: {}", (Object)DEFAULT_NUM_DIRECT_ARENA);
            if (throwable == null) {
                logger.debug("-Dio.netty.allocator.pageSize: {}", (Object)DEFAULT_PAGE_SIZE);
            } else {
                logger.debug("-Dio.netty.allocator.pageSize: {}", (Object)DEFAULT_PAGE_SIZE, (Object)throwable);
            }
            if (throwable3 == null) {
                logger.debug("-Dio.netty.allocator.maxOrder: {}", (Object)DEFAULT_MAX_ORDER);
            } else {
                logger.debug("-Dio.netty.allocator.maxOrder: {}", (Object)DEFAULT_MAX_ORDER, (Object)throwable3);
            }
            logger.debug("-Dio.netty.allocator.chunkSize: {}", (Object)(DEFAULT_PAGE_SIZE << DEFAULT_MAX_ORDER));
            logger.debug("-Dio.netty.allocator.smallCacheSize: {}", (Object)DEFAULT_SMALL_CACHE_SIZE);
            logger.debug("-Dio.netty.allocator.normalCacheSize: {}", (Object)DEFAULT_NORMAL_CACHE_SIZE);
            logger.debug("-Dio.netty.allocator.maxCachedBufferCapacity: {}", (Object)DEFAULT_MAX_CACHED_BUFFER_CAPACITY);
            logger.debug("-Dio.netty.allocator.cacheTrimInterval: {}", (Object)DEFAULT_CACHE_TRIM_INTERVAL);
            logger.debug("-Dio.netty.allocator.cacheTrimIntervalMillis: {}", (Object)DEFAULT_CACHE_TRIM_INTERVAL_MILLIS);
            logger.debug("-Dio.netty.allocator.useCacheForAllThreads: {}", (Object)DEFAULT_USE_CACHE_FOR_ALL_THREADS);
            logger.debug("-Dio.netty.allocator.maxCachedByteBuffersPerChunk: {}", (Object)DEFAULT_MAX_CACHED_BYTEBUFFERS_PER_CHUNK);
        }
        DEFAULT = new PooledByteBufAllocator(PlatformDependent.directBufferPreferred());
    }
}

