/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import pro.gravit.repackage.io.netty.buffer.AbstractReferenceCountedByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.buffer.PoolArenasCache;
import pro.gravit.repackage.io.netty.buffer.PoolChunk;
import pro.gravit.repackage.io.netty.buffer.PooledDuplicatedByteBuf;
import pro.gravit.repackage.io.netty.buffer.PooledSlicedByteBuf;
import pro.gravit.repackage.io.netty.util.Recycler$EnhancedHandle;
import pro.gravit.repackage.io.netty.util.internal.ObjectPool$Handle;

abstract class PooledByteBuf<T>
extends AbstractReferenceCountedByteBuf {
    private final Recycler$EnhancedHandle<PooledByteBuf<T>> recyclerHandle;
    protected PoolChunk<T> chunk;
    protected long handle;
    protected T memory;
    protected int offset;
    protected int length;
    int maxLength;
    PoolArenasCache cache;
    ByteBuffer tmpNioBuf;
    private ByteBufAllocator allocator;

    protected PooledByteBuf(ObjectPool$Handle<? extends PooledByteBuf<T>> objectPool$Handle, int n) {
        super(n);
        this.recyclerHandle = (Recycler$EnhancedHandle)objectPool$Handle;
    }

    void init(PoolChunk<T> poolChunk, ByteBuffer byteBuffer, long l, int n, int n2, int n3, PoolArenasCache poolArenasCache) {
        this.init0(poolChunk, byteBuffer, l, n, n2, n3, poolArenasCache);
    }

    void initUnpooled(PoolChunk<T> poolChunk, int n) {
        this.init0(poolChunk, null, 0L, 0, n, n, null);
    }

    private void init0(PoolChunk<T> poolChunk, ByteBuffer byteBuffer, long l, int n, int n2, int n3, PoolArenasCache poolArenasCache) {
        assert (l >= 0L);
        assert (poolChunk != null);
        assert (!PoolChunk.isSubpage(l) || poolChunk.arena.size2SizeIdx(n3) <= poolChunk.arena.smallMaxSizeIdx) : "Allocated small sub-page handle for a buffer size that isn't \"small.\"";
        poolChunk.incrementPinnedMemory(n3);
        this.chunk = poolChunk;
        this.memory = poolChunk.memory;
        this.tmpNioBuf = byteBuffer;
        this.allocator = poolChunk.arena.parent;
        this.cache = poolArenasCache;
        this.handle = l;
        this.offset = n;
        this.length = n2;
        this.maxLength = n3;
    }

    final void reuse(int n) {
        this.maxCapacity(n);
        this.resetRefCnt();
        this.setIndex0(0, 0);
        this.discardMarks();
    }

    @Override
    public final int capacity() {
        return this.length;
    }

    @Override
    public int maxFastWritableBytes() {
        return Math.min(this.maxLength, this.maxCapacity()) - this.writerIndex;
    }

    @Override
    public final ByteBuf capacity(int n) {
        if (n == this.length) {
            this.ensureAccessible();
            return this;
        }
        this.checkNewCapacity(n);
        if (!this.chunk.unpooled) {
            if (n > this.length) {
                if (n <= this.maxLength) {
                    this.length = n;
                    return this;
                }
            } else if (n > this.maxLength >>> 1 && (this.maxLength > 512 || n > this.maxLength - 16)) {
                this.length = n;
                this.trimIndicesToCapacity(n);
                return this;
            }
        }
        this.chunk.decrementPinnedMemory(this.maxLength);
        this.chunk.arena.reallocate(this, n, true);
        return this;
    }

    @Override
    public final ByteBufAllocator alloc() {
        return this.allocator;
    }

    @Override
    public final ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    @Override
    public final ByteBuf unwrap() {
        return null;
    }

    @Override
    public final ByteBuf retainedDuplicate() {
        return PooledDuplicatedByteBuf.newInstance(this, this, this.readerIndex(), this.writerIndex());
    }

    @Override
    public final ByteBuf retainedSlice() {
        int n = this.readerIndex();
        return this.retainedSlice(n, this.writerIndex() - n);
    }

    @Override
    public final ByteBuf retainedSlice(int n, int n2) {
        return PooledSlicedByteBuf.newInstance(this, this, n, n2);
    }

    protected final ByteBuffer internalNioBuffer() {
        ByteBuffer byteBuffer = this.tmpNioBuf;
        if (byteBuffer == null) {
            this.tmpNioBuf = byteBuffer = this.newInternalNioBuffer(this.memory);
        } else {
            byteBuffer.clear();
        }
        return byteBuffer;
    }

    protected abstract ByteBuffer newInternalNioBuffer(T var1);

    @Override
    protected final void deallocate() {
        if (this.handle >= 0L) {
            long l = this.handle;
            this.handle = -1L;
            this.memory = null;
            this.chunk.decrementPinnedMemory(this.maxLength);
            this.chunk.arena.free(this.chunk, this.tmpNioBuf, l, this.maxLength, this.cache);
            this.tmpNioBuf = null;
            this.chunk = null;
            this.cache = null;
            this.recyclerHandle.unguardedRecycle(this);
        }
    }

    protected final int idx(int n) {
        return this.offset + n;
    }

    final ByteBuffer _internalNioBuffer(int n, int n2, boolean bl) {
        n = this.idx(n);
        ByteBuffer byteBuffer = bl ? this.newInternalNioBuffer(this.memory) : this.internalNioBuffer();
        byteBuffer.limit(n + n2).position(n);
        return byteBuffer;
    }

    ByteBuffer duplicateInternalNioBuffer(int n, int n2) {
        this.checkIndex(n, n2);
        return this._internalNioBuffer(n, n2, true);
    }

    @Override
    public final ByteBuffer internalNioBuffer(int n, int n2) {
        this.checkIndex(n, n2);
        return this._internalNioBuffer(n, n2, false);
    }

    @Override
    public final int nioBufferCount() {
        return 1;
    }

    @Override
    public final ByteBuffer nioBuffer(int n, int n2) {
        return this.duplicateInternalNioBuffer(n, n2).slice();
    }

    @Override
    public final ByteBuffer[] nioBuffers(int n, int n2) {
        return new ByteBuffer[]{this.nioBuffer(n, n2)};
    }

    @Override
    public final boolean isContiguous() {
        return true;
    }

    @Override
    public final int getBytes(int n, GatheringByteChannel gatheringByteChannel, int n2) {
        return gatheringByteChannel.write(this.duplicateInternalNioBuffer(n, n2));
    }

    @Override
    public final int readBytes(GatheringByteChannel gatheringByteChannel, int n) {
        this.checkReadableBytes(n);
        int n2 = gatheringByteChannel.write(this._internalNioBuffer(this.readerIndex, n, false));
        this.readerIndex += n2;
        return n2;
    }

    @Override
    public final int getBytes(int n, FileChannel fileChannel, long l, int n2) {
        return fileChannel.write(this.duplicateInternalNioBuffer(n, n2), l);
    }

    @Override
    public final int readBytes(FileChannel fileChannel, long l, int n) {
        this.checkReadableBytes(n);
        int n2 = fileChannel.write(this._internalNioBuffer(this.readerIndex, n, false), l);
        this.readerIndex += n2;
        return n2;
    }

    @Override
    public final int setBytes(int n, ScatteringByteChannel scatteringByteChannel, int n2) {
        try {
            return scatteringByteChannel.read(this.internalNioBuffer(n, n2));
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    @Override
    public final int setBytes(int n, FileChannel fileChannel, long l, int n2) {
        try {
            return fileChannel.read(this.internalNioBuffer(n, n2), l);
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }
}

