/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.common;

import com.sun.jna.Platform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.linux.proc.Auxv;
import oshi.hardware.CentralProcessor;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.tuples.Triplet;

@ThreadSafe
public abstract class AbstractCentralProcessor
implements CentralProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCentralProcessor.class);
    private final Supplier<CentralProcessor.ProcessorIdentifier> cpuid = Memoizer.memoize(this::queryProcessorId);
    private final Supplier<Long> maxFreq = Memoizer.memoize(this::queryMaxFreq, Memoizer.defaultExpiration());
    private final Supplier<long[]> currentFreq = Memoizer.memoize(this::queryCurrentFreq, Memoizer.defaultExpiration());
    private final Supplier<Long> contextSwitches = Memoizer.memoize(this::queryContextSwitches, Memoizer.defaultExpiration());
    private final Supplier<Long> interrupts = Memoizer.memoize(this::queryInterrupts, Memoizer.defaultExpiration());
    private final Supplier<long[]> systemCpuLoadTicks = Memoizer.memoize(this::querySystemCpuLoadTicks, Memoizer.defaultExpiration());
    private final Supplier<long[][]> processorCpuLoadTicks = Memoizer.memoize(this::queryProcessorCpuLoadTicks, Memoizer.defaultExpiration());
    private final int physicalPackageCount;
    private final int physicalProcessorCount;
    private final int logicalProcessorCount;
    private final List<CentralProcessor.LogicalProcessor> logicalProcessors;
    private final List<CentralProcessor.PhysicalProcessor> physicalProcessors;
    private final List<CentralProcessor.ProcessorCache> processorCaches;

    protected AbstractCentralProcessor() {
        Set set;
        Triplet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>> triplet = this.initProcessorCounts();
        this.logicalProcessors = Collections.unmodifiableList(triplet.getA());
        if (triplet.getB() == null) {
            set = this.logicalProcessors.stream().map(logicalProcessor -> (logicalProcessor.getPhysicalPackageNumber() << 16) + logicalProcessor.getPhysicalProcessorNumber()).collect(Collectors.toSet());
            List list = set.stream().sorted().map(n -> new CentralProcessor.PhysicalProcessor(n >> 16, (int)(n & 0xFFFF))).collect(Collectors.toList());
            this.physicalProcessors = Collections.unmodifiableList(list);
        } else {
            this.physicalProcessors = Collections.unmodifiableList(triplet.getB());
        }
        this.processorCaches = triplet.getC() == null ? Collections.emptyList() : Collections.unmodifiableList(triplet.getC());
        set = new HashSet();
        for (CentralProcessor.LogicalProcessor logicalProcessor2 : this.logicalProcessors) {
            int n2 = logicalProcessor2.getPhysicalPackageNumber();
            set.add(n2);
        }
        this.logicalProcessorCount = this.logicalProcessors.size();
        this.physicalProcessorCount = this.physicalProcessors.size();
        this.physicalPackageCount = set.size();
    }

    protected abstract Triplet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>> initProcessorCounts();

    protected abstract CentralProcessor.ProcessorIdentifier queryProcessorId();

    @Override
    public CentralProcessor.ProcessorIdentifier getProcessorIdentifier() {
        return this.cpuid.get();
    }

    @Override
    public long getMaxFreq() {
        return this.maxFreq.get();
    }

    protected long queryMaxFreq() {
        return Arrays.stream(this.getCurrentFreq()).max().orElse(-1L);
    }

    @Override
    public long[] getCurrentFreq() {
        long[] lArray = this.currentFreq.get();
        if (lArray.length == this.getLogicalProcessorCount()) {
            return lArray;
        }
        long[] lArray2 = new long[this.getLogicalProcessorCount()];
        Arrays.fill(lArray2, lArray[0]);
        return lArray2;
    }

    protected abstract long[] queryCurrentFreq();

    @Override
    public long getContextSwitches() {
        return this.contextSwitches.get();
    }

    protected abstract long queryContextSwitches();

    @Override
    public long getInterrupts() {
        return this.interrupts.get();
    }

    protected abstract long queryInterrupts();

    @Override
    public List<CentralProcessor.LogicalProcessor> getLogicalProcessors() {
        return this.logicalProcessors;
    }

    @Override
    public List<CentralProcessor.PhysicalProcessor> getPhysicalProcessors() {
        return this.physicalProcessors;
    }

    @Override
    public List<CentralProcessor.ProcessorCache> getProcessorCaches() {
        return this.processorCaches;
    }

    @Override
    public long[] getSystemCpuLoadTicks() {
        return this.systemCpuLoadTicks.get();
    }

    protected abstract long[] querySystemCpuLoadTicks();

    @Override
    public long[][] getProcessorCpuLoadTicks() {
        return this.processorCpuLoadTicks.get();
    }

    protected abstract long[][] queryProcessorCpuLoadTicks();

    @Override
    public double getSystemCpuLoadBetweenTicks(long[] lArray) {
        if (lArray.length != CentralProcessor.TickType.values().length) {
            throw new IllegalArgumentException("Provited tick array length " + lArray.length + " should have " + CentralProcessor.TickType.values().length + " elements");
        }
        long[] lArray2 = this.getSystemCpuLoadTicks();
        long l = 0L;
        for (int i = 0; i < lArray2.length; ++i) {
            l += lArray2[i] - lArray[i];
        }
        long l2 = lArray2[CentralProcessor.TickType.IDLE.getIndex()] + lArray2[CentralProcessor.TickType.IOWAIT.getIndex()] - lArray[CentralProcessor.TickType.IDLE.getIndex()] - lArray[CentralProcessor.TickType.IOWAIT.getIndex()];
        LOG.trace("Total ticks: {}  Idle ticks: {}", (Object)l, (Object)l2);
        return l > 0L ? (double)(l - l2) / (double)l : 0.0;
    }

    @Override
    public double[] getProcessorCpuLoadBetweenTicks(long[][] lArray) {
        long[][] lArray2 = this.getProcessorCpuLoadTicks();
        if (lArray.length != lArray2.length || lArray[0].length != CentralProcessor.TickType.values().length) {
            throw new IllegalArgumentException("Provided tick array length " + lArray.length + " should be " + lArray2.length + ", each subarray having " + CentralProcessor.TickType.values().length + " elements");
        }
        double[] dArray = new double[lArray2.length];
        for (int i = 0; i < lArray2.length; ++i) {
            long l = 0L;
            for (int j = 0; j < lArray2[i].length; ++j) {
                l += lArray2[i][j] - lArray[i][j];
            }
            long l2 = lArray2[i][CentralProcessor.TickType.IDLE.getIndex()] + lArray2[i][CentralProcessor.TickType.IOWAIT.getIndex()] - lArray[i][CentralProcessor.TickType.IDLE.getIndex()] - lArray[i][CentralProcessor.TickType.IOWAIT.getIndex()];
            LOG.trace("CPU: {}  Total ticks: {}  Idle ticks: {}", i, l, l2);
            dArray[i] = l > 0L && l2 >= 0L ? (double)(l - l2) / (double)l : 0.0;
        }
        return dArray;
    }

    @Override
    public int getLogicalProcessorCount() {
        return this.logicalProcessorCount;
    }

    @Override
    public int getPhysicalProcessorCount() {
        return this.physicalProcessorCount;
    }

    @Override
    public int getPhysicalPackageCount() {
        return this.physicalPackageCount;
    }

    protected static String createProcessorID(String string, String string2, String string3, String[] stringArray) {
        long l = 0L;
        long l2 = ParseUtil.parseLongOrDefault(string, 0L);
        long l3 = ParseUtil.parseLongOrDefault(string2, 0L);
        long l4 = ParseUtil.parseLongOrDefault(string3, 0L);
        l |= l2 & 0xFL;
        l |= (l3 & 0xFL) << 4;
        l |= (l3 & 0xF0L) << 12;
        l |= (l4 & 0xFL) << 8;
        l |= (l4 & 0xFF0L) << 16;
        long l5 = 0L;
        if (Platform.isLinux()) {
            l5 = Auxv.queryAuxv().getOrDefault(16, 0L);
        }
        if (l5 > 0L) {
            l |= l5 << 32;
        } else {
            String[] stringArray2 = stringArray;
            int n = stringArray2.length;
            block64: for (int i = 0; i < n; ++i) {
                String string4;
                switch (string4 = stringArray2[i]) {
                    case "fpu": {
                        l |= 0x100000000L;
                        continue block64;
                    }
                    case "vme": {
                        l |= 0x200000000L;
                        continue block64;
                    }
                    case "de": {
                        l |= 0x400000000L;
                        continue block64;
                    }
                    case "pse": {
                        l |= 0x800000000L;
                        continue block64;
                    }
                    case "tsc": {
                        l |= 0x1000000000L;
                        continue block64;
                    }
                    case "msr": {
                        l |= 0x2000000000L;
                        continue block64;
                    }
                    case "pae": {
                        l |= 0x4000000000L;
                        continue block64;
                    }
                    case "mce": {
                        l |= 0x8000000000L;
                        continue block64;
                    }
                    case "cx8": {
                        l |= 0x10000000000L;
                        continue block64;
                    }
                    case "apic": {
                        l |= 0x20000000000L;
                        continue block64;
                    }
                    case "sep": {
                        l |= 0x80000000000L;
                        continue block64;
                    }
                    case "mtrr": {
                        l |= 0x100000000000L;
                        continue block64;
                    }
                    case "pge": {
                        l |= 0x200000000000L;
                        continue block64;
                    }
                    case "mca": {
                        l |= 0x400000000000L;
                        continue block64;
                    }
                    case "cmov": {
                        l |= 0x800000000000L;
                        continue block64;
                    }
                    case "pat": {
                        l |= 0x1000000000000L;
                        continue block64;
                    }
                    case "pse-36": {
                        l |= 0x2000000000000L;
                        continue block64;
                    }
                    case "psn": {
                        l |= 0x4000000000000L;
                        continue block64;
                    }
                    case "clfsh": {
                        l |= 0x8000000000000L;
                        continue block64;
                    }
                    case "ds": {
                        l |= 0x20000000000000L;
                        continue block64;
                    }
                    case "acpi": {
                        l |= 0x40000000000000L;
                        continue block64;
                    }
                    case "mmx": {
                        l |= 0x80000000000000L;
                        continue block64;
                    }
                    case "fxsr": {
                        l |= 0x100000000000000L;
                        continue block64;
                    }
                    case "sse": {
                        l |= 0x200000000000000L;
                        continue block64;
                    }
                    case "sse2": {
                        l |= 0x400000000000000L;
                        continue block64;
                    }
                    case "ss": {
                        l |= 0x800000000000000L;
                        continue block64;
                    }
                    case "htt": {
                        l |= 0x1000000000000000L;
                        continue block64;
                    }
                    case "tm": {
                        l |= 0x2000000000000000L;
                        continue block64;
                    }
                    case "ia64": {
                        l |= 0x4000000000000000L;
                        continue block64;
                    }
                    case "pbe": {
                        l |= Long.MIN_VALUE;
                        continue block64;
                    }
                }
            }
        }
        return String.format("%016X", l);
    }

    protected List<CentralProcessor.PhysicalProcessor> createProcListFromDmesg(List<CentralProcessor.LogicalProcessor> list, Map<Integer, String> map) {
        boolean bl = map.values().stream().distinct().count() > 1L;
        ArrayList<CentralProcessor.PhysicalProcessor> arrayList = new ArrayList<CentralProcessor.PhysicalProcessor>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (CentralProcessor.LogicalProcessor logicalProcessor : list) {
            int n;
            int n2 = logicalProcessor.getPhysicalPackageNumber();
            int n3 = (n2 << 16) + (n = logicalProcessor.getPhysicalProcessorNumber());
            if (hashSet.contains(n3)) continue;
            hashSet.add(n3);
            String string = map.getOrDefault(logicalProcessor.getProcessorNumber(), "");
            int n4 = 0;
            if (bl && (string.startsWith("ARM Cortex") && ParseUtil.getFirstIntValue(string) >= 70 || string.startsWith("Apple") && (string.contains("Firestorm") || string.contains("Avalanche")))) {
                n4 = 1;
            }
            arrayList.add(new CentralProcessor.PhysicalProcessor(n2, n, n4, string));
        }
        arrayList.sort(Comparator.comparingInt(CentralProcessor.PhysicalProcessor::getPhysicalPackageNumber).thenComparingInt(CentralProcessor.PhysicalProcessor::getPhysicalProcessorNumber));
        return arrayList;
    }

    public static List<CentralProcessor.ProcessorCache> orderedProcCaches(Set<CentralProcessor.ProcessorCache> set) {
        return set.stream().sorted(Comparator.comparing(processorCache -> -1000 * processorCache.getLevel() + 100 * processorCache.getType().ordinal() - Integer.highestOneBit(processorCache.getCacheSize()))).collect(Collectors.toList());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getProcessorIdentifier().getName());
        stringBuilder.append("\n ").append(this.getPhysicalPackageCount()).append(" physical CPU package(s)");
        stringBuilder.append("\n ").append(this.getPhysicalProcessorCount()).append(" physical CPU core(s)");
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n = 0;
        for (CentralProcessor.PhysicalProcessor physicalProcessor : this.getPhysicalProcessors()) {
            int n2 = physicalProcessor.getEfficiency();
            hashMap.merge(n2, 1, Integer::sum);
            if (n2 <= n) continue;
            n = n2;
        }
        int n3 = hashMap.getOrDefault(n, 0);
        int n4 = this.getPhysicalProcessorCount() - n3;
        if (n4 > 0) {
            stringBuilder.append(" (").append(n3).append(" performance + ").append(n4).append(" efficiency)");
        }
        stringBuilder.append("\n ").append(this.getLogicalProcessorCount()).append(" logical CPU(s)");
        stringBuilder.append('\n').append("Identifier: ").append(this.getProcessorIdentifier().getIdentifier());
        stringBuilder.append('\n').append("ProcessorID: ").append(this.getProcessorIdentifier().getProcessorID());
        stringBuilder.append('\n').append("Microarchitecture: ").append(this.getProcessorIdentifier().getMicroarchitecture());
        return stringBuilder.toString();
    }
}

