/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.ReflectionAccessFilter;
import com.google.gson.ReflectionAccessFilter$FilterResult;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.$Gson$Types;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.Excluder;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.Primitives;
import com.google.gson.internal.ReflectionAccessFilterHelper;
import com.google.gson.internal.bind.JsonAdapterAnnotationTypeAdapterFactory;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$1;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$BoundField;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$FieldReflectionAdapter;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$RecordAdapter;
import com.google.gson.internal.reflect.ReflectionHelper;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ReflectiveTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;
    private final FieldNamingStrategy fieldNamingPolicy;
    private final Excluder excluder;
    private final JsonAdapterAnnotationTypeAdapterFactory jsonAdapterFactory;
    private final List<ReflectionAccessFilter> reflectionFilters;

    public ReflectiveTypeAdapterFactory(ConstructorConstructor constructorConstructor, FieldNamingStrategy fieldNamingStrategy, Excluder excluder, JsonAdapterAnnotationTypeAdapterFactory jsonAdapterAnnotationTypeAdapterFactory, List<ReflectionAccessFilter> list) {
        this.constructorConstructor = constructorConstructor;
        this.fieldNamingPolicy = fieldNamingStrategy;
        this.excluder = excluder;
        this.jsonAdapterFactory = jsonAdapterAnnotationTypeAdapterFactory;
        this.reflectionFilters = list;
    }

    private boolean includeField(Field field, boolean bl) {
        return !this.excluder.excludeClass(field.getType(), bl) && !this.excluder.excludeField(field, bl);
    }

    private List<String> getFieldNames(Field field) {
        SerializedName serializedName = field.getAnnotation(SerializedName.class);
        if (serializedName == null) {
            String string = this.fieldNamingPolicy.translateName(field);
            return Collections.singletonList(string);
        }
        String string = serializedName.value();
        String[] stringArray = serializedName.alternate();
        if (stringArray.length == 0) {
            return Collections.singletonList(string);
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length + 1);
        arrayList.add(string);
        Collections.addAll(arrayList, stringArray);
        return arrayList;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        boolean bl;
        Class<T> clazz = typeToken.getRawType();
        if (!Object.class.isAssignableFrom(clazz)) {
            return null;
        }
        ReflectionAccessFilter$FilterResult reflectionAccessFilter$FilterResult = ReflectionAccessFilterHelper.getFilterResult(this.reflectionFilters, clazz);
        if (reflectionAccessFilter$FilterResult == ReflectionAccessFilter$FilterResult.BLOCK_ALL) {
            throw new JsonIOException("ReflectionAccessFilter does not permit using reflection for " + clazz + ". Register a TypeAdapter for this type or adjust the access filter.");
        }
        boolean bl2 = bl = reflectionAccessFilter$FilterResult == ReflectionAccessFilter$FilterResult.BLOCK_INACCESSIBLE;
        if (ReflectionHelper.isRecord(clazz)) {
            ReflectiveTypeAdapterFactory$RecordAdapter<T> reflectiveTypeAdapterFactory$RecordAdapter = new ReflectiveTypeAdapterFactory$RecordAdapter<T>(clazz, this.getBoundFields(gson, typeToken, clazz, bl, true), bl);
            return reflectiveTypeAdapterFactory$RecordAdapter;
        }
        ObjectConstructor<T> objectConstructor = this.constructorConstructor.get(typeToken);
        return new ReflectiveTypeAdapterFactory$FieldReflectionAdapter<T>(objectConstructor, this.getBoundFields(gson, typeToken, clazz, bl, false));
    }

    private static <M extends AccessibleObject> void checkAccessible(Object object, M m) {
        if (!ReflectionAccessFilterHelper.canAccess(m, Modifier.isStatic(((Member)((Object)m)).getModifiers()) ? null : object)) {
            String string = ReflectionHelper.getAccessibleObjectDescription(m, true);
            throw new JsonIOException(string + " is not accessible and ReflectionAccessFilter does not permit making it accessible. Register a TypeAdapter for the declaring type, adjust the access filter or increase the visibility of the element and its declaring type.");
        }
    }

    private ReflectiveTypeAdapterFactory$BoundField createBoundField(Gson gson, Field field, Method method, String string, TypeToken<?> typeToken, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4;
        boolean bl5 = Primitives.isPrimitive(typeToken.getRawType());
        int n = field.getModifiers();
        boolean bl6 = Modifier.isStatic(n) && Modifier.isFinal(n);
        JsonAdapter jsonAdapter = field.getAnnotation(JsonAdapter.class);
        TypeAdapter<?> typeAdapter = null;
        if (jsonAdapter != null) {
            typeAdapter = this.jsonAdapterFactory.getTypeAdapter(this.constructorConstructor, gson, typeToken, jsonAdapter);
        }
        boolean bl7 = bl4 = typeAdapter != null;
        if (typeAdapter == null) {
            typeAdapter = gson.getAdapter(typeToken);
        }
        TypeAdapter<?> typeAdapter2 = typeAdapter;
        return new ReflectiveTypeAdapterFactory$1(this, string, field, bl, bl2, bl3, method, bl4, typeAdapter2, gson, typeToken, bl5, bl6);
    }

    private Map<String, ReflectiveTypeAdapterFactory$BoundField> getBoundFields(Gson gson, TypeToken<?> typeToken, Class<?> clazz, boolean bl, boolean bl2) {
        LinkedHashMap<String, ReflectiveTypeAdapterFactory$BoundField> linkedHashMap = new LinkedHashMap<String, ReflectiveTypeAdapterFactory$BoundField>();
        if (clazz.isInterface()) {
            return linkedHashMap;
        }
        Class<?> clazz2 = clazz;
        while (clazz != Object.class) {
            Field[] fieldArray = clazz.getDeclaredFields();
            if (clazz != clazz2 && fieldArray.length > 0) {
                ReflectionAccessFilter$FilterResult reflectionAccessFilter$FilterResult = ReflectionAccessFilterHelper.getFilterResult(this.reflectionFilters, clazz);
                if (reflectionAccessFilter$FilterResult == ReflectionAccessFilter$FilterResult.BLOCK_ALL) {
                    throw new JsonIOException("ReflectionAccessFilter does not permit using reflection for " + clazz + " (supertype of " + clazz2 + "). Register a TypeAdapter for this type or adjust the access filter.");
                }
                bl = reflectionAccessFilter$FilterResult == ReflectionAccessFilter$FilterResult.BLOCK_INACCESSIBLE;
            }
            for (Field field : fieldArray) {
                Object object;
                boolean bl3 = this.includeField(field, true);
                boolean bl4 = this.includeField(field, false);
                if (!bl3 && !bl4) continue;
                Method method = null;
                if (bl2) {
                    if (Modifier.isStatic(field.getModifiers())) {
                        bl4 = false;
                    } else {
                        method = ReflectionHelper.getAccessor(clazz, field);
                        if (!bl) {
                            ReflectionHelper.makeAccessible(method);
                        }
                        if (method.getAnnotation(SerializedName.class) != null && field.getAnnotation(SerializedName.class) == null) {
                            object = ReflectionHelper.getAccessibleObjectDescription(method, false);
                            throw new JsonIOException("@SerializedName on " + (String)object + " is not supported");
                        }
                    }
                }
                if (!bl && method == null) {
                    ReflectionHelper.makeAccessible(field);
                }
                object = $Gson$Types.resolve(typeToken.getType(), clazz, field.getGenericType());
                List<String> list = this.getFieldNames(field);
                ReflectiveTypeAdapterFactory$BoundField reflectiveTypeAdapterFactory$BoundField = null;
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    String string = list.get(i);
                    if (i != 0) {
                        bl3 = false;
                    }
                    ReflectiveTypeAdapterFactory$BoundField reflectiveTypeAdapterFactory$BoundField2 = this.createBoundField(gson, field, method, string, TypeToken.get((Type)object), bl3, bl4, bl);
                    ReflectiveTypeAdapterFactory$BoundField reflectiveTypeAdapterFactory$BoundField3 = linkedHashMap.put(string, reflectiveTypeAdapterFactory$BoundField2);
                    if (reflectiveTypeAdapterFactory$BoundField != null) continue;
                    reflectiveTypeAdapterFactory$BoundField = reflectiveTypeAdapterFactory$BoundField3;
                }
                if (reflectiveTypeAdapterFactory$BoundField == null) continue;
                throw new IllegalArgumentException("Class " + clazz2.getName() + " declares multiple JSON fields named '" + reflectiveTypeAdapterFactory$BoundField.name + "'; conflict is caused by fields " + ReflectionHelper.fieldToString(reflectiveTypeAdapterFactory$BoundField.field) + " and " + ReflectionHelper.fieldToString(field));
            }
            typeToken = TypeToken.get($Gson$Types.resolve(typeToken.getType(), clazz, clazz.getGenericSuperclass()));
            clazz = typeToken.getRawType();
        }
        return linkedHashMap;
    }

    static /* synthetic */ void access$000(Object object, AccessibleObject accessibleObject) {
        ReflectiveTypeAdapterFactory.checkAccessible(object, accessibleObject);
    }
}

